% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{fixef.gam}
\alias{fixef.gam}
\alias{fixef.gamm}
\alias{fixef.lm}
\alias{fixef.glm}
\alias{fixed_effects}
\alias{fixed_effects.default}
\title{Extract fixed effects estimates from a fitted GAM}
\usage{
\method{fixef}{gam}(object, ...)

\method{fixef}{gamm}(object, ...)

\method{fixef}{lm}(object, ...)

\method{fixef}{glm}(object, ...)

fixed_effects(object, ...)

\method{fixed_effects}{default}(object, ...)
}
\arguments{
\item{object}{a fitted GAM}

\item{...}{arguments passed to other methods}
}
\description{
Extract fixed effects estimates from a fitted GAM
}
\examples{
load_mgcv()

# run example if lme4 is available
if (require("lme4")) {
  data(sleepstudy, package = "lme4")
  m <- gam(
    Reaction ~ Days + s(Subject, bs = "re") +
      s(Days, Subject, bs = "re"),
    data = sleepstudy, method = "REML"
  )
  fixef(m)
}
}
