% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-evaluate-smooth.R
\name{draw.evaluated_parametric_term}
\alias{draw.evaluated_parametric_term}
\title{Plot estimated parametric effects}
\usage{
\method{draw}{evaluated_parametric_term}(
  object,
  ci_level = 0.95,
  constant = NULL,
  fun = NULL,
  xlab,
  ylab,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  rug = TRUE,
  position = "identity",
  response_range = NULL,
  ...
)
}
\arguments{
\item{object}{an object, the result of a call to
\code{\link[=evaluate_parametric_term]{evaluate_parametric_term()}}.}

\item{ci_level}{numeric between 0 and 1; the coverage of credible interval.}

\item{constant}{numeric; a constant to add to the estimated values of the
smooth. \code{constant}, if supplied, will be added to the estimated value
before the confidence band is computed.}

\item{fun}{function; a function that will be applied to the estimated values
and confidence interval before plotting. Can be a function or the name of a
function. Function \code{fun} will be applied after adding any \code{constant}, if
provided.}

\item{xlab}{character or expression; the label for the x axis. If not
supplied, a suitable label will be generated from \code{object}.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated from \code{object}.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{rug}{For \code{evaluate_parametric_terms()}, a logical to
indicate if a rug plot should be drawn.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{response_range}{numeric; a vector of two values giving the range of
response data for the guide. Used to fix plots to a common scale/range.
Ignored if \code{show} is set to \code{"se"}.}

\item{...}{arguments passed to other methods.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Plots estimated univariate and bivariate smooths using ggplot2.
}
\author{
Gavin L. Simpson
}
