% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/income_tax.R
\name{income_tax}
\alias{income_tax}
\title{Income tax payable}
\usage{
income_tax(
  income,
  fy.year = NULL,
  age = NULL,
  .dots.ATO = NULL,
  System = NULL,
  return.mode = c("numeric", "integer"),
  nThread = getOption("grattan.nThread", 1L)
)
}
\arguments{
\item{income}{The individual assessable income.}

\item{fy.year}{The financial year in which the income was earned. Tax years 2000-01 to 2018-19 are supported, as well as the tax year 2019-20, for convenience. 
If \code{fy.year} is not given, the current financial year is used by default.}

\item{age}{The individual's age. Ignored if \code{.dots.ATO} is provided (and contains
an age variable such as \code{age_range} or \code{Birth_year}).}

\item{.dots.ATO}{A data.frame that contains additional information about the individual's circumstances, with columns the same as in the ATO sample files.

Age variables in \code{.dots.ATO} take precedence over \code{age} and providing both
is a warning.}

\item{System}{A \code{tax-system} created by \code{System()} or \code{NULL}, the default,
corresponding to the tax system of the given year.}

\item{return.mode}{The mode (numeric or integer) of the returned vector.}

\item{nThread}{Number of threads to use.}
}
\value{
The total personal income tax payable.
}
\description{
Income tax payable
}
\details{
The function is inflexible by design.
It is designed to return the correct tax payable in a year, not to model the tax payable 
under different tax settings. (Use \code{\link{model_income_tax}} for that purpose.)


The function aims to produce the personal income tax payable for the inputs given
in the tax year \code{fy.year}. The function is specified to produce the most accurate 
calculation of personal income tax given the variables in the ATO's 2\% sample files.
 However, many components are absent from these files, while other components could
 not be computed reliably.
 
For the 2018-19 tax year, the function calculates
\describe{
\item{tax on ordinary taxable income}{The tax as specified in Schedule 7 of the 
\emph{Income Tax Rates Act 1986} (Cth).}
\item{Medicare levy}{See \code{\link{medicare_levy}} for details.}
\item{LITO}{See \code{\link{lito}} for details.}
\item{SAPTO}{See \code{\link{sapto}}. For years preceding the introduction of SAPTO, 
the maximum offset is assumed to apply to those above age 65 (since the sample files only provide 5-year 
age groups).}
\item{SBTO}{See \code{\link{small_business_tax_offset}} for details.}
\item{Historical levies}{The flood levy and the temporary budget repair levy.}
}

Notably, when used with a 2\% sample file, the function will not be able to correctly account
for different tax rates and offsets among taxpayers with dependants since the sample files
(as of 2015-16) do not have this information.
}
\examples{

## Income tax payable on a taxable income of 50,000 
## for the 2013-14 tax year
income_tax(50e3, "2013-14")

## Calculate tax for each lodger in the 2013-14 sample file.

 # library(data.table)
 # library(taxstats)
  
 # s1314 <- as.data.table(sample_file_1314)
 # s1314[, tax := income_tax(Taxable_Income, "2013-14", .dots.ATO = s1314)]

}
\author{
Tim Cameron, Brendan Coates, Matthew Katzen, Hugh Parsonage, William Young
}
