% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tetrads.R
\name{Tetrads}
\alias{Tetrads}
\title{Tetrads}
\usage{
Tetrads(y, dist, x, k = "USA", ell = "JPN", multiway_vcov = TRUE, data,
  ...)
}
\arguments{
\item{y}{name (type: character) of the dependent variable in the dataset 
\code{data}, e.g. trade flows. It is logged and
taken as the dependent variable in the estimation.}

\item{dist}{name (type: character) of the distance variable in the dataset 
\code{data} containing a measure of distance between all pairs of bilateral
partners. It is logged automatically when the function is executed.}

\item{x}{vector of names (type: character) of those bilateral variables in 
the dataset \code{data} that should be taken as the independent variables 
in the estimation. If an independent variable is a dummy variable,
it should be of type numeric (0/1) in the dataset. If an independent variable 
is defined as a ratio, it should be logged. 
Unilateral effects drop as the ratio of ratios is taken.}

\item{k}{reference importing country, default is set to \code{"USA"}.}

\item{ell}{reference exporting country, default is set to \code{"JPN"}.}

\item{multiway_vcov}{(type: logic) optional; determines whether a function
implementing Cameron, Gelbach, & Miller (2011) multi-way clustering of 
variance-covariance matrices in the package \code{multiway_vcov} is used
for the estimation. In case \code{multiway_vcov=TRUE}, the 
\code{cluster.vcov} function is used. The default value is set to \code{TRUE}.}

\item{data}{name of the dataset to be used (type: character). 
To estimate gravity equations, a square gravity dataset including bilateral 
flows defined by the argument \code{y}, ISO-codes of type character 
(called \code{iso_o} for the country of origin and \code{iso_d} for the 
destination country), a distance measure defined by the argument \code{dist} 
and other potential influences given as a vector in \code{x} are required. 
All dummy variables should be of type numeric (0/1). Missing trade flows as 
well as incomplete rows should be excluded from the dataset. 
Furthermore, flows equal to zero should be excluded as the gravity equation 
is estimated in its additive form.
When using panel data, a variable for the time may be included in the 
dataset. Note that the variable for the time dimension should be of 
type: factor. See the references for more information on panel data.}

\item{...}{additional arguments to be passed to functions used by 
\code{Tetrads}.}
}
\value{
The function returns the summary of the estimated gravity model as an 
\code{\link[stats]{lm}}-object.
}
\description{
\code{Tetrads} estimates gravity models 
by taking the ratio of the ratio of flows.
}
\details{
\code{Tetrads} is an estimation method for gravity models
developed by Head et al. (2010) (see the references for
more information). 
To execute the function a square gravity dataset with all pairs of 
countries, ISO-codes for the country of origin and destination, a measure of 
distance between the bilateral partners as well as all 
information that should be considered as dependent an independent 
variables is needed. 
Make sure the ISO-codes are of type "character".
Missing bilateral flows as well as incomplete rows should be 
excluded from the dataset. 
Furthermore, flows equal to zero should be excluded as the gravity equation 
is estimated in its additive form.  

The function \code{Tetrads} utilizes the multiplicative form of the
gravity equation. After choosing a reference importer \code{k} and 
exporter \code{ell} one can eliminate importer and exporter fixed effects 
by taking the ratio of ratios. Only those exporters trading with the 
reference importer and importers trading with the reference exporter will 
remain for the estimation. Therefore, reference countries should
preferably be countries which trade with every other country in the dataset. 
After restircting the data in this way, \code{Tetrads} estimates the gravity 
equation in its additive form by OLS.
As, by taking the ratio of ratios, all monadic effects diminish, no
unilateral variables such as GDP can be included as independent variables.

\code{Tetrads} estimation can be used for both, cross-sectional as well as 
panel data. Nonetheless, the function is designed to be consistent with the 
Stata code for cross-sectional data provided on the website
\href{https://sites.google.com/site/hiegravity/}{Gravity Equations: Workhorse, Toolkit, and Cookbook}
when choosing robust estimation.
The function \code{Tetrads} was therefore tested for cross-sectional data.
If Tetrads is used for panel data, the user may has to drop distance as an
independent variable as time-invariant effects drop.
For applying \code{Tetrads} to panel data see Head, Mayer and Ries (2010).
}
\examples{
\dontrun{
data(Gravity_no_zeros)

Tetrads(y="flow", dist="distw", x=c("rta"), k="USA", ell="JPN", 
multiway_vcov=TRUE, data=Gravity_no_zeros)

Tetrads(y="flow", dist="distw", x=c("rta", "comcur", "contig"), 
k="USA", ell="JPN", multiway_vcov=FALSE, data=Gravity_no_zeros)
}

\dontshow{
# examples for CRAN checks:
# executable in < 5 sec together with the examples above
# not shown to users

data(Gravity_no_zeros)
# choose exemplarily 10 biggest countries for check data
countries_chosen <- names(sort(table(Gravity_no_zeros$iso_o), decreasing = TRUE)[1:10])
grav_small <- Gravity_no_zeros[Gravity_no_zeros$iso_o \%in\% countries_chosen,]
Tetrads(y="flow", dist="distw", x=c("rta"), k=countries_chosen[1], ell=countries_chosen[2], multiway_vcov=FALSE, data=grav_small)
}

}
\references{
For information on \code{Tetrads} see

Cameron, A. C., Gelbach, J. B., and Miller, D. L. (2011) <DOI:10.3386/t0327>

Head, K., Mayer, T., & Ries, J. (2010) <DOI:10.1016/j.jinteco.2010.01.002>

For more information on gravity models, theoretical foundations and
estimation methods in general see 

Anderson, J. E. (1979) <DOI:10.12691/wjssh-2-2-5>

Anderson, J. E. (2010) <DOI:10.3386/w16576>

Anderson, J. E. and van Wincoop, E. (2003) <DOI:10.3386/w8079> 

Baier, S. L. and Bergstrand, J. H. (2009) <DOI:10.1016/j.jinteco.2008.10.004>

Baier, S. L. and Bergstrand, J. H. (2010) in Van Bergeijk, P. A., & Brakman, S. (Eds.) (2010) chapter 4 <DOI:10.1111/j.1467-9396.2011.01000.x>

Head, K. and Mayer, T. (2014) <DOI:10.1016/B978-0-444-54314-1.00003-3>

Santos-Silva, J. M. C. and Tenreyro, S. (2006) <DOI:10.1162/rest.88.4.641> 

and the citations therein.


See \href{https://sites.google.com/site/hiegravity/}{Gravity Equations: Workhorse, Toolkit, and Cookbook} for gravity datasets and Stata code for estimating gravity models.


For estimating gravity equations using panel data see 

Egger, P., & Pfaffermayr, M. (2003) <DOI:10.1007/s001810200146>

Gomez-Herrera, E. (2013) <DOI:10.1007/s00181-012-0576-2>

and the references therein.
}
\seealso{
\code{\link[stats]{lm}}, \code{\link[lmtest]{coeftest}}, 
\code{\link[multiwayvcov]{cluster.vcov}}
}
