% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misssbm.R
\docType{class}
\name{misssbm_path-class}
\alias{misssbm_path-class}
\title{Stochastic Block Model with sampling scheme hierarchical fit results class}
\description{
An S4 class to represent a hierarchical fit of a stochastic block model, extend \code{\link{icl_path-class}}.
}
\section{Slots}{

\describe{
\item{\code{model}}{a \code{\link{sbm-class}} object to store the model fitted}

\item{\code{name}}{generative model name}

\item{\code{icl}}{icl value of the fitted model}

\item{\code{K}}{number of extracted clusters over row and columns}

\item{\code{cl}}{a numeric vector with row and columns cluster indexes}

\item{\code{obs_stats}}{a list with the following elements:
\itemize{
\item counts: numeric vector of size K with number of elements in each clusters
\item x_counts: matrix of size K*K with the number of observed links between each pair of clusters 
\item x_counts_obs: matrix of size K*K with the number of observed dyads between each pair of clusters 
}}

\item{\code{logalpha}}{value of log(alpha)}

\item{\code{ggtree}}{data.frame with complete merge tree for easy plotting with \code{ggplot2}}

\item{\code{tree}}{numeric vector with merge tree \code{tree[i]} contains the index of \code{i} father}

\item{\code{train_hist}}{data.frame with training history information (details depends on the training procedure)}
}}

