% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Implied_Volatility.R
\name{Implied_Volatility}
\alias{Implied_Volatility}
\title{Computes the implied volatility for various options via Newton's method}
\usage{
Implied_Volatility(
  option_price,
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  dividend_yield = 0,
  model = "Black_Scholes",
  option_type = "European",
  payoff = "call",
  start_volatility = 0.3,
  precision = 1e-06,
  max_iter = 30
)
}
\arguments{
\item{option_price}{\itemize{
\item current price of the option
}}

\item{initial_price}{\itemize{
\item initial price of the underlying asset
}}

\item{exercise_price}{\itemize{
\item strike price of the option
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity in years
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{model}{\itemize{
\item the model to be chosen
}}

\item{option_type}{in c("European", "American", "Asian", "Digital") - the
type of option to be considered}

\item{payoff}{\itemize{
\item in c("call", "put")
}}

\item{start_volatility}{initial guess}

\item{precision}{precision of the computation}

\item{max_iter}{maximal number of iterations of the approximation}
}
\value{
Named vector containing the values of the greeks specified in the
parameter \code{greek}.
}
\description{
Computes the implied volatility for various options via Newton's method
}
\examples{
Implied_Volatility(15, r = 0.05, option_type = "Asian",
payoff = "call")
}
