% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_auxiliaryFunctions.R
\name{is_identifiable}
\alias{is_identifiable}
\title{Identifiability in case of latent variables}
\usage{
is_identifiable(obj, tobj)
}
\arguments{
\item{obj}{should be an object of class \code{RootDepSet}}

\item{tobj}{should be an object of class \code{Tree}}
}
\value{
No return value
}
\description{
It verifies if the identifiability criterion in case of latent variables is satisfied on the level of subsets.
Basically it verifies for each subset whether the identifiability criterion is satisfied for the subgraph
induced by this subset: verifies if every node with latent variables within the subgraph has degree at least
 three. It is applicable only for tree models.
}
\examples{
 seg<- graph(c(1,2,
2,3,
2,4,
4,5,
5,6,
5,7), directed = FALSE)
name_stat<- c("Paris", "2", "Meaux", "Melun", "5", "Nemours", "Sens")
seg<- set.vertex.attribute(seg, "name", V(seg), name_stat)
# we need some data to create the object of class "Tree"
seg_data<- matrix(rnorm(10*7), 10, 7)
colnames(seg_data)<- name_stat
tobj<- Tree(seg, seg_data[,c("Paris", "Meaux", "Melun", "Nemours", "Sens")])
# create the neighborhood of order one and call the function "is_identifiable"
nobj<- Neighborhood()
nobj<- subset(nobj, 1, seg, U_bar=getNoDataNodes(tobj))
is_identifiable(nobj, tobj)
nobj<- subset(nobj, 2, seg, U_bar=getNoDataNodes(tobj))
is_identifiable(nobj, tobj)
 # See also Vignette "Subsets and Coordinates"
}
