% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gremlin.R
\name{anova.gremlin}
\alias{anova.gremlin}
\title{anova() for gremlin objects}
\usage{
\method{anova}{gremlin}(object, ..., model.names = NULL)
}
\arguments{
\item{object}{An object of \code{class} \sQuote{gremlin}.}

\item{\dots}{Additional objects of \code{class} \sQuote{gremlin}.}

\item{model.names}{Optional character vector with model names to be used in
the anova table}
}
\value{
A \code{data.frame} containing the nested comparison of model
  \code{object}s via a REML likelihood ratio test.
}
\description{
REML Likelihood Ratio Tests for gremlin models using anova()
}
\examples{
mod11 <- gremlinR(WWG11 ~ sex - 1,
random = ~ calf,
data = Mrode11,
Gstart = matrix(0.1), Rstart = matrix(0.4),
maxit = 50, v = 2, algit = "EM")
logLik(mod11)
}
\author{
\email{matthewwolak@gmail.com}
}
