% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grex.R
\name{grex}
\alias{grex}
\title{Gene ID Mapping for Genotype-Tissue Expression (GTEx) Data}
\usage{
grex(ensembl_id)
}
\arguments{
\item{ensembl_id}{Character vector of Ensembl IDs}
}
\value{
This function returns a data frame with the
same number of rows as the length of input Ensembl IDs, containing:
\itemize{
\item \code{ensembl_id} - Input Ensembl ID
\item \code{entrez_id} - Entrez Gene ID
\item \code{hgnc_symbol} - HGNC gene symbol
\item \code{hgnc_name} - HGNC gene name
\item \code{cyto_loc} - Cytogenetic location
\item \code{uniprot_id} - UniProt ID
\item \code{gene_biotype} - Gene type
}
The elements that cannot be mapped will be \code{NA}.
}
\description{
Map Ensembl IDs to Entrez Gene ID, HGNC symbol, and UniProt ID,
with basic annotation information such as gene type.
}
\examples{
# Ensembl IDs in GTEx v6p gene count data
data("gtexv6p")
# select 100 IDs as example
id = gtexv6p[101:200]
df = grex(id)
# Rows that have a mapped Entrez ID
df[!is.na(df$"entrez_id"),
   c("ensembl_id", "entrez_id", "gene_biotype")]
}

