% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.alm}
\alias{predict.alm}
\alias{predict.greybox}
\alias{forecast}
\alias{forecast.greybox}
\title{Forecasting using greybox functions}
\usage{
\method{predict}{alm}(object, newdata, interval = c("none", "confidence",
  "prediction"), level = 0.95, side = c("both", "upper", "lower"), ...)

\method{predict}{greybox}(object, newdata, interval = c("none",
  "confidence", "prediction"), level = 0.95, side = c("both", "upper",
  "lower"), ...)
}
\arguments{
\item{object}{Time series model for which forecasts are required.}

\item{newdata}{Forecast horizon}

\item{interval}{Type of intervals to construct: either "confidence" or
"prediction". Can be abbreviated}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{side}{What type of interval to produce: \code{"both"} - produces both
lower and upper bounds of the interval, \code{"upper"} - upper only, \code{"lower"}
- respectively lower only. In the \code{"both"} case the probability is split into
two parts: ((1-level)/2, (1+level)/2). When \code{"upper"} is specified, then
the intervals for (0, level) are constructed Finally, with \code{"lower"} the interval
for (1-level, 1) is returned.}

\item{...}{Other arguments.}
}
\value{
\code{predict.greybox()} returns object of class "predict.greybox",
which contains:
\itemize{
\item \code{model} - the estimated model.
\item \code{mean} - the expected values.
\item \code{fitted} - fitted values of the model.
\item \code{lower} - lower bound of prediction / confidence intervals.
\item \code{upper} - upper bound of prediction / confidence intervals.
\item \code{level} - confidence level.
\item \code{newdata} - the data provided in the call to the function.
\item \code{variances} - conditional variance for the holdout sample.
In case of \code{interval="prediction"} includes variance of the error.
}

\code{predict.alm()} is based on \code{predict.greybox()} and returns
object of class "predict.alm", which in addition contains:
\itemize{
\item \code{location} - the location parameter of the distribution.
\item \code{scale} - the scale parameter of the distribution.
\item \code{distribution} - name of the fitted distribution.
}
}
\description{
\code{predict} is a function for predictions from various model fitting
functions. The function invokes particular method, corresponding to the
class of the first argument.
}
\details{
Although this function is called "forecast", it has functionality similar to
"predict" function.
}
\examples{

xreg <- cbind(rlaplace(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rlaplace(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
inSample <- xreg[1:80,]
outSample <- xreg[-c(1:80),]

ourModel <- alm(y~x1+x2, inSample, distribution="dlaplace")

predict(ourModel,outSample)
predict(ourModel,outSample,interval="c")
plot(predict(ourModel,outSample,interval="p"))

}
\seealso{
\code{\link[stats]{predict.lm}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{ts}
\keyword{univar}
