% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace.R
\name{dlaplace}
\alias{dlaplace}
\alias{Laplace}
\alias{plaplace}
\alias{qlaplace}
\alias{rlaplace}
\title{Laplace Distribution}
\usage{
dlaplace(q, mu = 0, scale = 1, log = FALSE)

plaplace(q, mu = 0, scale = 1)

qlaplace(p, mu = 0, scale = 1)

rlaplace(n = 1, mu = 0, scale = 1)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{vector of location parameters (means).}

\item{scale}{vector of mean absolute errors.}

\item{log}{if \code{TRUE}, then probabilities are returned in
logarithms.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. Should be a single number.}
}
\value{
Depending on the function, various things are returned
(usually either vector or scalar):
\itemize{
\item \code{dlaplace} returns the density function value for the
provided parameters.
\item \code{plaplace} returns the value of the cumulative function
for the provided parameters.
\item \code{qlaplace} returns quantiles of the distribution. Depending
on what was provided in \code{p}, \code{mu} and \code{scale}, this
can be either a vector or a matrix, or an array.
\item \code{rlaplace} returns a vector of random variables
generated from the Laplace distribution. Depending on what was
provided in \code{mu} and \code{scale}, this can be either a vector
or a matrix or an array.
}
}
\description{
Density, cumulative distribution, quantile functions and random number
generation for the Laplace distribution with the location parameter mu
and the scale parameter (which is equal to Mean Absolute Error, aka
Mean Absolute Deviation).
}
\details{
When mu=0 and scale=1, the Laplace distribution becomes standardized.
The distribution has the following density function:

f(x) = 1/(2 scale) exp(-abs(x-mu) / scale)

Both \code{plaplace} and \code{qlaplace} are returned for the lower
tail of the distribution.
}
\examples{
x <- dlaplace(c(-100:100)/10, 0, 1)
plot(x, type="l")

x <- plaplace(c(-100:100)/10, 0, 1)
plot(x, type="l")

qlaplace(c(0.025,0.975), 0, c(1,2))

x <- rlaplace(1000, 0, 1)
hist(x)

}
\references{
\itemize{
\item Wikipedia page on Laplace distribution:
\url{https://en.wikipedia.org/wiki/Laplace_distribution}.
}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{distribution}
