% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_tools.R
\name{get_sample_weights}
\alias{get_sample_weights}
\title{Given a trained forest and test data, compute the training sample weights for each test point.}
\usage{
get_sample_weights(forest, newdata = NULL, num.threads = NULL)
}
\arguments{
\item{forest}{The trained forest.}

\item{newdata}{Points at which predictions should be made. If NULL,
makes out-of-bag predictions on the training set instead
(i.e., provides predictions at Xi using only trees that did
not use the i-th training example).#' @param max.depth Maximum depth of splits to consider.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}
}
\value{
A sparse matrix where each row represents a test sample, and each column is a sample in the
        training data. The value at (i, j) gives the weight of training sample j for test sample i.
}
\description{
During normal prediction, these weights are computed as an intermediate step towards producing estimates.
This function allows for examining the weights directly, so they could be potentially be used as the
input to a different analysis.
}
\examples{
\dontrun{
p <- 10
n <- 100
X <- matrix(2 * runif(n * p) - 1, n, p)
Y <- (X[, 1] > 0) + 2 * rnorm(n)
rrf <- regression_forest(X, Y, mtry = p)
sample.weights.oob <- get_sample_weights(rrf)

n.test <- 15
X.test <- matrix(2 * runif(n.test * p) - 1, n.test, p)
sample.weights <- get_sample_weights(rrf, X.test)
}

}
