% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_forest.R
\name{custom_forest}
\alias{custom_forest}
\title{Custom forest}
\usage{
custom_forest(X, Y, sample.fraction = 0.5, mtry = ceiling(2 * ncol(X)/3),
  num.trees = 2000, num.threads = NULL, min.node.size = NULL,
  keep.inbag = FALSE, honesty = TRUE, alpha = 0.05, seed = NULL)
}
\arguments{
\item{X}{The covariates used in the regression.}

\item{Y}{The outcome.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty is used, these subsamples will
further be cut in half.}

\item{mtry}{Number of variables tried for each split.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{min.node.size}{Minimum number of observations in each tree leaf.}

\item{keep.inbag}{Currently not used.}

\item{honesty}{Should honest splitting (i.e., sub-sample splitting) be used?}

\item{alpha}{Maximum imbalance of a split.}

\item{seed}{The seed of the c++ random number generator.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A trained regression forest object.
}
\description{
Trains a custom forest model.
}
\examples{
# Train a custom forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
Y = X[,1] * rnorm(n)
c.forest = custom_forest(X, Y)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
c.pred = predict(c.forest, X.test)

}
