% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-array-image.R
\name{grid.pattern_image}
\alias{grid.pattern_image}
\title{Image patterned grobs}
\usage{
grid.pattern_image(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  filename = "",
  type = "fit",
  scale = 1,
  gravity = switch(type, tile = "southwest", "center"),
  filter = "lanczos",
  alpha = gp$alpha \%||\% NA_real_,
  aspect_ratio = 1,
  key_scale_factor = 1,
  res = getOption("ggpattern_res", 72),
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{filename}{Image of filename or URL}

\item{type}{Image scaling type}

\item{scale}{Extra scaling}

\item{gravity}{Position of image within area.  \code{magick::gravity_types()} returns a vector of supported values.}

\item{filter}{Filter to use when scaling. \code{magick::filter_types()} returns a vector of supported values.}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{aspect_ratio}{Override aspect ratio}

\item{key_scale_factor}{Additional scale factor for legend}

\item{res}{Assumed resolution (in pixels per graphic device inch) to use when creating array pattern.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_image()} draws an image pattern onto the graphic device.
}
\details{
Here is a description of the \code{type} arguments:
\describe{
\item{expand}{Scale the image beyond the bounding box and crop it such that
the image fully covers the width and the height of the region.}
\item{fit}{Scale the image such that either the width or the height of the image fits in the bounding box.
Affected by \code{gravity}}
\item{none}{Position a single image in the region without attempting to scale to the bounding box size.
Affected by \code{scale} and \code{gravity}.}
\item{squish}{Distort the image to cover the bounding box of the region.}
\item{tile}{Repeat the image to cover the bounding box.  Affected by \code{tile}.}
}
}
\examples{
  if (require("magick")) {
    x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    logo_filename <- system.file("img", "Rlogo.png" , package = "png")
    grid.pattern_image(x_hex, y_hex, filename = logo_filename, type = "fit")

    # "tile" `type` image pattern depends on `magick` functionality
    # which is not reliable across platforms
    grid::grid.newpage()
    try(grid.pattern_image(x_hex, y_hex, filename = logo_filename,
                           type = "tile"))
  }
}
\seealso{
\code{\link[=grid.pattern_placeholder]{grid.pattern_placeholder()}} is an image pattern that uses images
downloaded from the internet.
}
