% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_session_duration.R
\name{sample_session_duration}
\alias{sample_session_duration}
\title{Sample Session Duration}
\usage{
sample_session_duration(input_df, priors, n_samples = 50000)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str),
sum_sessions (dbl), and sum_duration (dbl).}

\item{priors}{Optional list of priors k0 and theta0.
Default \eqn{Gamma(1, 250)} will be use otherwise.}

\item{n_samples}{Optional integer value. Defaults to 50,000 samples.}
}
\value{
input_df with 2 new nested columns `gamma_params` and `samples`
}
\description{
Adds 2 new nested columns to the input_df: `gamma_params` and `samples`
    `gamma_params` in each row should be a tibble of length 2 (\eqn{k}
        and \eqn{\theta} parameters)
    `samples` in each row should be a tibble of length `n_samples`
}
\details{
See update_rules vignette for a mathematical representation.
\deqn{duration_i ~ Exponential(\lambda)}
\deqn{\lambda ~ Gamma(k, \theta)}
Session Duration is sampled from a Gamma distribution with a Exponential likelihood
of an individual leaving the site or ending a session at time t.

This is not always the case, so verify your data follows the shape of
an exponential distribution before using this.
}
