% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{specify_decimal_p}
\alias{specify_decimal_p}
\title{Custom function for getting specified number of decimal places in
results for p-value}
\usage{
specify_decimal_p(x, k = NULL, p.value = FALSE)
}
\arguments{
\item{x}{A numeric variable.}

\item{k}{Number of digits after decimal point (should be an integer).}

\item{p.value}{Decides whether the number is a p-value (Default: \code{FALSE}).}
}
\value{
Formatted numeric values.
}
\description{
Function to format an R object for pretty printing with a
specified (\code{k}) number of decimal places. The function also allows highly
significant p-values to be denoted as "p < 0.001" rather than "p = 0.000".
}
\note{
This is a helper function used internally in the package and not
exported. In case you want to use it, you can do so by
\code{groupedstats:::specify_decimal_p}. Note that it is \code{:::} and not \code{::}.
}
\author{
Indrajeet Patil
}
\keyword{internal}
