% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{sd_median}
\alias{sd_median}
\title{Calculate median SD score by age for each parameter.}
\usage{
sd_median(param, sex, agedays, sd.orig)
}
\arguments{
\item{param}{Vector identifying each measurement, may be 'WEIGHTKG', or 'HEIGHTCM'.}

\item{sex}{Vector identifying the gender of the subject, may be 'M', 'm', or 0 for males, vs. 'F', 'f' or 1 for females.}

\item{agedays}{Numeric vector containing the age in days at each measurement.}

\item{sd.orig}{Vector of previously calculated standard deviation (SD) scores for each measurement before re-centering.}
}
\value{
Table of data with median SD-scores per day of life by gender and parameter.
}
\description{
Calculate median SD score by age for each parameter.
}
\examples{
# Run on 1 subject
df_stats <- as.data.frame(syngrowth)
df_stats <- df_stats[df_stats$subjid == df_stats$subjid[1], ]

# Get the original standard deviations
measurement_to_z <- read_anthro(cdc.only = TRUE)
sd.orig <- measurement_to_z(df_stats$param,
                       df_stats$agedays,
                       df_stats$sex,
                       df_stats$measurement,
                       TRUE)

# Calculate median standard deviations
sd.m <- sd_median(df_stats$param,
                  df_stats$sex,
                  df_stats$agedays,
                  sd.orig)
}
