% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize-growth-by-plate.R
\name{SummarizeGrowthByPlate}
\alias{SummarizeGrowthByPlate}
\title{Summarize Growth Curves}
\usage{
SummarizeGrowthByPlate(plate, t_trim = 0, bg_correct = "min",
  plot_fit = FALSE, plot_file = "growthcurver.pdf")
}
\arguments{
\item{plate}{A data.table with at least two columns. One column contains
timepoints that measurements were taken (e.g., hours) and
must be named "time". An optional column can be included
called "blank" that contains the blank readings for
background correction (make sure to select the "blank"
bg_correct option if you provide a blank column).
Each remaining column contains the
absorbance readings from a single well in a plate.}

\item{t_trim}{Measurements taken after this time should not be included
in fitting the curve. If stationary phase is variable,
this may give you a better fit. A value of 0 means no
trimming. Defaults to no trimming (0).}

\item{bg_correct}{The background correction method to use. No background
correction is performed for "none". Specifying
"min" subtracts the smallest value in a column from all the
rows in that column, and specifying "blank" subtracts
the values from the blank vector from the data_n vector.}

\item{plot_fit}{TRUE if you want to generate a pdf file that plots all
columns provided in the plate along with the growthcurver's
fit. The default value is FALSE, which generates no plots.}

\item{plot_file}{The name of the file to save the plots to if you set
plot_fit to TRUE. The default file is called
"growthcurver.pdf".}
}
\value{
A data.table containing the summary metrics and residual
                  error from the fit of the logistic curve to the data.
                  The names of the input columns are used to identify each
                  well (or sample).
}
\description{
This function finds the parameters that describe the input data's growth
for a plate of growth curves.
It does so by fitting the logistic curve to your growth curve measurements.
}
\details{
The logistic curve equation is
\deqn{N_t = \frac{N_0 K} {N_0 + (K-N_0)e^{-rt}}}{N_t = N_0 K / (N_0 + (K - N_0) exp(-rt))}
where \eqn{N_t} is the number
of cells (or the absorbance reading) at time t, \eqn{N_0} is the initial
cell count (or absorbance reading), K is the carrying capacity, and r is the
growth rate.

The fitness proxies returned are the parameters of the logistic equation
and the area under the curve (a measure that integrates the effects
of \eqn{N_0}, K, and r). See \code{\link{gcfit}} for more documentation on these.

This method expects that your data adhere to a particular format.
\itemize{
 \item The data are provided in a data.frame
 \item One column in the data.frame is named "time" and contains the
       time measurements (e.g., hours).
 \item Each remaining column contains the
       readings from a single well in a plate reader. The name of the column
       will be used to identify the sample in the output data.
 \item There are no missing values or non-numeric data in the data.frame.
}
}
\examples{
#Get the summary metrics for the entire plate of sample data provided
#with the Growthcurver package

#First, load the example data provided with Growthcurver. Note that there is
#a column named "time" -- this is necessary for Growthcurver to know which
#column contains the time measurements. In this dataset, the repeated
#measurements from a single well in a plate are given in a column of data.

myPlate <- growthdata
names(myPlate)

#Next, do the analysis for all the columns.
summary_plate <- SummarizeGrowthByPlate(plate = myPlate)

#The output is a data frame that contains the information on the best
#fit for each column of data.
head(summary_plate)      # Use head to display just the first few rows

}
\seealso{
See the accompanying Vignette for an example of how to use and interpret
SummarizeGrowthByPlate. \url{bit.ly/1p7w6dJ}
}

