% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.R
\name{define_enroll_rate}
\alias{define_enroll_rate}
\title{Define enrollment rate}
\usage{
define_enroll_rate(duration, rate, stratum = "All")
}
\arguments{
\item{duration}{A numeric vector of piecewise study duration interval.}

\item{rate}{A numeric vector of enrollment rate in each \code{duration}.}

\item{stratum}{A character vector of stratum name.}
}
\value{
An \code{enroll_rate} data frame.
}
\description{
Define enrollment rate
}
\examples{
# Define enroll rate without stratum
define_enroll_rate(
  duration = c(2, 2, 10),
  rate = c(3, 6, 9)
)

# Define enroll rate with stratum
define_enroll_rate(
  stratum = c("low", "low", "high"),
  duration = c(2, 2, 10),
  rate = c(3, 6, 9)
)
}
