% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sos.R
\name{Sos}
\alias{Sos}
\alias{as.Sos}
\alias{as.Sos.Arma}
\alias{as.Sos.Ma}
\alias{as.Sos.Sos}
\alias{as.Sos.Zpg}
\title{Second-order sections}
\usage{
Sos(sos, g)

as.Sos(x, ...)

## S3 method for class 'Arma'
as.Sos(x, ...)

## S3 method for class 'Ma'
as.Sos(x, ...)

## S3 method for class 'Sos'
as.Sos(x, ...)

## S3 method for class 'Zpg'
as.Sos(x, ...)
}
\arguments{
\item{sos}{second-order sections representation of the model}

\item{g}{overall gain factor}

\item{x}{model to be converted.}

\item{...}{additional arguments (ignored).}
}
\value{
A list of class \code{Sos} with the following list elements:
\describe{
  \item{sos}{second-order section representation of the model, returned as an
    \code{L x 6} matrix, one row for each section \code{1:L}. Each row
    consists of an \code{[B, A]}, pair, where \code{B = c(b0, b1, b2)}, and
    \code{A = c(1, a1, a2)}, the filer coefficients for each section. Each
    \code{b0} entry must be nonzero for each section.}
  \item{g}{overall gain factor that scales any one of the \eqn{B_i} vectors}
}
}
\description{
Create or convert filter models to second-order sections form.
}
\details{
\code{as.Sos} converts from other forms, including \code{Arma}, \code{Ma},
and \code{Zpg}.
}
\examples{
ba <- butter(3, 0.2)
sos <- as.Sos(ba)

}
\seealso{
\code{\link{Arma}}, \code{\link{Ma}}, \code{\link{Zpg}}
}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
