% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitrevorder.R
\name{bitrevorder}
\alias{bitrevorder}
\title{Permute input to bit-reversed order}
\usage{
bitrevorder(x, index.return = FALSE)
}
\arguments{
\item{x}{input data, specified as a vector. The length of \code{x} must be an
integer power of 2.}

\item{index.return}{logical indicating if the ordering index vector should be
returned as well. Default: \code{FALSE}.}
}
\value{
The bit-reversed input vector. If \code{index.return = TRUE}, then
  a list containing the bit-reversed input vector (\code{y}), and the
  digit-reversed indices (\code{i}).
}
\description{
Reorder the elements of the input vector in bit-reversed order.
}
\details{
This function is equivalent to calling \code{digitrevorder(x, 2)}, and is
useful for prearranging filter coefficients so that bit-reversed ordering
does not have to be performed as part of an fft or ifft computation.
}
\examples{
x <- 0:15
v <- bitrevorder(x)
dec2bin <- function(x, l)
  substr(paste(as.integer(rev(intToBits(x))), collapse = ""),
  32 - l + 1, 32)
x_bin <- sapply(x, dec2bin, 4)
v_bin <- sapply(v, dec2bin, 4)
data.frame(x, x_bin, v, v_bin)

}
\seealso{
\code{\link{digitrevorder}}, \code{\link{fft}}, \code{\link{ifft}}
}
\author{
Mike Miller.\cr
 Port to to by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
