% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invfreq.R
\name{invfreq}
\alias{invfreq}
\alias{invfreqs}
\alias{invfreqz}
\title{Inverse Frequency Response}
\usage{
invfreq(
  h,
  w,
  nb,
  na,
  wt = rep(1, length(w)),
  plane = c("z", "s"),
  method = c("ols", "tls", "qr"),
  norm = TRUE
)

invfreqs(
  h,
  w,
  nb,
  na,
  wt = rep(1, length(w)),
  method = c("ols", "tls", "qr"),
  norm = TRUE
)

invfreqz(
  h,
  w,
  nb,
  na,
  wt = rep(1, length(w)),
  method = c("ols", "tls", "qr"),
  norm = TRUE
)
}
\arguments{
\item{h}{Frequency response, specified as a vector}

\item{w}{Angular frequencies at which \code{h} is computed, specified as a
vector}

\item{nb, na}{Desired order of the numerator and denominator polynomials,
specified as positive integers.}

\item{wt}{Weighting factors, specified as a vector of the same length as
\code{w}. Default: \code{rep(1, length(w))}}

\item{plane}{\code{"z"} (default) for discrete-time spectra; \code{"s"} for
continuous-time spectra}

\item{method}{minimization method used to solve the normal equations, one of:
\describe{
  \item{"ols"}{ordinary least squares (default)}
  \item{"tls"}{total least squares}
  \item{"qr"}{QR decomposition}
}}

\item{norm}{logical indicating whether frequencies must be normalized to
avoid matrices with rank deficiency. Default: TRUE}
}
\value{
A list of class \code{'Arma'} with the following list elements:
\describe{
  \item{b}{moving average (MA) polynomial coefficients}
  \item{a}{autoregressive (AR) polynomial coefficients}
}
}
\description{
Identify filter parameters from frequency response data.
}
\details{
Given a desired (one-sided, complex) spectrum \code{h(w)} at equally spaced
angular frequencies \eqn{w = (2 \pi k) / N}, k = 0, ... N-1, this function
finds the filter \code{B(z)/A(z)} or \code{B(s)/A(s)} with \code{nb} zeroes
and \code{na} poles. Optionally, the fit-errors can be weighted with respect
to frequency according to the weights \code{wt}.
}
\examples{
order <- 6  # order of test filter
fc <- 1/2   # sampling rate / 4
n <- 128    # frequency grid size
ba <- butter(order, fc)
hw <- freqz(ba, n)
BA = invfreq(hw$h, hw$w, order, order)
HW = freqz(BA, n)
plot(hw$w, abs(hw$h), type = "l", xlab = "Frequency (rad/sample)",
  ylab = "Magnitude")
lines(HW$w, abs(HW$h), col = "red")
legend("topright", legend = c("Original", "Measured"), lty  = 1, col = 1:2)
err <- norm(hw$h - HW$h, type = "2")
title(paste('L2 norm of frequency response error =', err))

}
\references{
\url{https://ccrma.stanford.edu/~jos/filters/FFT_Based_Equation_Error_Method.html}
}
\author{
Julius O. Smith III, Rolf Schirmacher, Andrew Fitting, Pascal
  Dupuis.\cr Conversion to R by Geert van Boxtel,
  \email{G.J.M.vanBoxtel@gmail.com}.
}
