% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arburg.R
\name{arburg}
\alias{arburg}
\title{Autoregressive model coefficients - Burg's method}
\usage{
arburg(x, p, criterion = NULL)
}
\arguments{
\item{x}{input data, specified as a numeric or complex vector or matrix. In
case of a vector it represents a single signal; in case of a matrix each
column is a signal.}

\item{p}{model order; number of poles in the AR model or limit to the number
of poles if a valid criterion is provided. Must be < length(x) - 2.}

\item{criterion}{model-selection criterion. Limits the number of poles so
that spurious poles are not added when the whitened data has no more
information in it. Recognized values are:
\describe{
  \item{AKICc}{approximate corrected Kullback information criterion
  (recommended)}
  \item{KIC}{Kullback information criterion}
  \item{AICc}{corrected Akaike information criterion}
  \item{AIC}{Akaike information criterion}
  \item{FPE}{final prediction error}
}
The default is to NOT use a model-selection criterion (NULL)}
}
\value{
A \code{list} containing the following elements:
  \describe{
    \item{a}{vector or matrix containing \code{(p+1)} autoregression
    coefficients. If \code{x} is a matrix, then each row of a corresponds to
    a column of \code{x}. \code{a} has \code{p + 1} columns.}
    \item{e}{white noise input variance, returned as a vector. If \code{x} is
    a matrix, then each element of e corresponds to a column of \code{x}.}
    \item{k}{Reflection coefficients defining the lattice-filter embodiment
    of the model returned as vector or a matrix. If \code{x} is a matrix,
    then each column of \code{k} corresponds to a column of \code{x}.
    \code{k} has \code{p} rows.}
  }
}
\description{
Calculate the coefficients of an autoregressive model using the whitening
lattice-filter method of Burg (1968)[1].
}
\details{
The inverse of the autoregressive model is a moving-average filter which
reduces \code{x} to white noise. The power spectrum of the AR model is an
estimate of the maximum entropy power spectrum of the data. The function
\code{ar_psd} calculates the power spectrum of the AR model.

For data input \code{x(n)} and white noise \code{e(n)}, the autoregressive
model is
\if{latex}{
\deqn{x(n) = \sqrt{v} \cdot e(n) + \sum_{k=1}^{p+1} a(k) \cdot x(n-k)}
}
\if{html}{\preformatted{
                          p+1
    x(n) = sqrt(v).e(n) + SUM a(k).x(n-k)
                          k=1
 }}

\code{arburg} does not remove the mean from the data. You should remove the
mean from the data if you want a power spectrum. A non-zero mean can produce
large errors in a power-spectrum estimate.  See \code{\link{detrend}}
}
\note{
AIC, AICc, KIC and AKICc are based on information theory. They  attempt
  to balance the complexity (or length) of the model against how well the
  model fits the data.  AIC and KIC are biased estimates of the asymmetric
  and the symmetric Kullback-Leibler divergence, respectively. AICc and AKICc
  attempt to correct the bias. See reference [2].
}
\examples{
A <- Arma(1, c(1, -2.7607, 3.8106, -2.6535, 0.9238))
y <- filter(A, 0.2 * rnorm(1024))
coefs <- arburg(y, 4)

}
\references{
[1] Burg, J.P. (1968) A new analysis technique for time series
  data, NATO advanced study Institute on Signal Processing with Emphasis on
  Underwater Acoustics, Enschede, Netherlands, Aug. 12-23, 1968.\cr
  [2] Seghouane, A. and Bekara, M. (2004). A small sample model selection
  criterion based on Kullback’s symmetric divergence. IEEE Trans. Sign.
  Proc., 52(12), pp 3314-3323,
}
\seealso{
\code{\link{ar_psd}}
}
\author{
Peter V. Lanspeary, \email{pvl@mecheng.adelaide.edu.au}.\cr
 Conversion to R by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}.
}
