% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp_kaiser.R
\name{qp_kaiser}
\alias{qp_kaiser}
\title{Kaiser FIR filter design}
\usage{
qp_kaiser(nb, at, linear = FALSE)
}
\arguments{
\item{nb}{number of frequency bands, specified as a scalar}

\item{at}{attenuation (in dB) in the stop band.}

\item{linear}{logical, indicating linear scaling. If FALSE (default), the
Kaiser window is multiplied by the ideal impulse response \eqn{h(n) = a
sinc(an)} and converted to its minimum-phase version by means of a Hilbert
transform.}
}
\value{
The FIR filter coefficients, of class \code{Ma}.
}
\description{
Compute FIR filter for use with a quasi-perfect reconstruction
polyphase-network filter bank.
}
\examples{
\donttest{
freqz(qp_kaiser(1, 20))
freqz(qp_kaiser(1, 40))
}

}
\seealso{
\code{\link{Ma}}, \code{\link{filter}}, \code{\link{fftfilt}},
  \code{\link{fir2}}
}
\author{
André Carezia, \email{andre@carezia.eng.br}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
