% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_AIC.R
\name{cp_AIC}
\alias{cp_AIC}
\title{Compute Akaike's information criterion}
\usage{
cp_AIC(ll, k)
}
\arguments{
\item{ll}{numeric vector of length 1 (or an object of class 'logLik') storing the log-likelihood of the model of interest}

\item{k}{numeric vector of length 1 storing the number of parameters estimated by the model}
}
\value{
numeric vector of length 1 storing the computed AIC.
}
\description{
Computes Akaike's information criterion for comparing competing models.
}
\examples{
# Fit some model
lm_out <- lm(mpg ~ cyl + disp, data = mtcars)

# Compute AIC with your function
AIC_M <- cp_AIC(
    ll = logLik(lm_out),
    k = length(coef(lm_out)) + 1 # intercept + reg coefs + error variance
)
}
\author{
Edoardo Costantini, 2023
}
