% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_gR2.R
\name{cp_gR2}
\alias{cp_gR2}
\title{Compute generalized R-squared}
\usage{
cp_gR2(ll_n, ll_f, n)
}
\arguments{
\item{ll_n}{numeric vector of length 1 (or an object of class 'logLik') storing the log-likelihood of the null (restricted) model}

\item{ll_f}{numeric vector of length 1 (or an object of class 'logLik') storing the log-likelihood of the full model}

\item{n}{numeric vector of length 1 storing the sample size of the data used to estimate the models}
}
\value{
numeric vector of length 1 storing the computed Cox and Snell generalized R-squared.
}
\description{
Computes the Cox and Snell generalized R-squared.
}
\details{
The Cox and Snell generalized R-squared is equal to the R-squared when applied to multiple linear regression. The highest value for this measure is 1 - exp(ll_n)^(2/n), which is usually < 1.
The null (restricted) model must be nested within the full model.
}
\examples{
# Fit a null model
lm_n <- lm(mpg ~ 1, data = mtcars)

# Fit a full model
lm_f <- lm(mpg ~ cyl + disp, data = mtcars)

# Compute generalized R2
gr2 <- cp_gR2(
    ll_n = as.numeric(logLik(lm_n)),
    ll_f = as.numeric(logLik(lm_f)),
    n = nobs(lm_f)
)

}
\references{
Allison, P. D. (2014, March). Measures of fit for logistic regression. In Proceedings of the SAS global forum 2014 conference (pp. 1-13). Cary, NC: SAS Institute Inc.
}
\author{
Edoardo Costantini, 2023
}
