% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SP_from_SA}
\alias{gsw_SP_from_SA}
\title{Convert from Absolute Salinity to Practical Salinity}
\usage{
gsw_SP_from_SA(SA, p, longitude, latitude)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [ dbar ]}

\item{longitude}{longitude in decimal degrees [ 0 to 360 or -180 to 180]}

\item{latitude}{latitude in decimal degrees [ -90 to 90 ]}
}
\value{
Practical Salinity (PSS-78) [ unitless ]
}
\description{
Calculate Practical Salinity from Absolute Salinity, pressure,
longitude, and latitude.
}
\details{
If SP is a matrix and if its dimensions correspond to the
lengths of longitude and latitude, then the latter are
converted to analogous matrices with \code{\link{expand.grid}}.

Note: unlike the corresponding Matlab function, this does not
return a flag indicating whether the location is in the ocean.
}
\examples{
gsw_SP_from_SA(34.7118, 10, 188, 4) # 34.548721553448317
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SP_from_SA.html}
}
\seealso{
\code{\link{gsw_SA_from_SP}} does the reverse, while \code{\link{gsw_SP_from_SK}}, \code{\link{gsw_SP_from_SR}} and \code{\link{gsw_SP_from_Sstar}} are similar to this.
}

