% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_from_entropy}
\alias{gsw_pt_from_entropy}
\title{Potential Temperature from Entropy}
\usage{
gsw_pt_from_entropy(SA, entropy)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{entropy}{specific entropy [ J/(degC*kg) ]}
}
\value{
potential temperature [ degC ]
}
\description{
Potential Temperature from Entropy
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(      34.7118,  34.8915,  35.0256,  34.8472, 34.7366, 34.7324)
entropy <- c(400.3892, 395.4378, 319.8668, 146.7910, 98.6471, 62.7919)
pt <- gsw_pt_from_entropy(SA, entropy)
expect_equal(pt, c(28.783179828078666, 28.420954825949291, 22.784952736245351,
                 10.230532066931868, 6.829213325916900, 4.324537782985845))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_from_entropy.html}
}
\seealso{
Other things related to entropy: \code{\link{gsw_CT_from_entropy}},
  \code{\link{gsw_entropy_first_derivatives}},
  \code{\link{gsw_entropy_from_pt}},
  \code{\link{gsw_entropy_from_t}},
  \code{\link{gsw_entropy_ice}}
}
