% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_frazil_properties}
\alias{gsw_frazil_properties}
\title{Properties of Frazil ice}
\usage{
gsw_frazil_properties(SA_bulk, h_bulk, p)
}
\arguments{
\item{SA_bulk}{Absolute Salinity of a combination of seawater and ice [ g/kg ]}

\item{h_bulk}{enthalpy of a mixture of seawater and ice [ J/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
a list containing \code{SA_final}, \code{h_final} and \code{w_Ih_final}.
}
\description{
Calculation of Absolute Salinity, Conservative Temperature, and ice mass fraction
based on bulk Absolute Salinity, bulk enthalpy, and pressure
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA_bulk <- c(  34.7118,   34.8915,   35.0256,   34.8472,   34.7366,   34.7324)
h_bulk <- c( -4.5544e4, -4.6033e4, -4.5830e4, -4.5589e4, -4.4948e4, -4.4027e4)
p <- c(             10,        50,       125,       250,       600,      1000)
r <- gsw_frazil_properties(SA_bulk, h_bulk, p)
expect_equal(r$SA_final, c(39.111030663000442, 39.407625769681573, 39.595789974885108,
                         39.481230045372889, 39.591177095552503, 39.826467709177123))
expect_equal(r$CT_final, c(-2.156311126114311, -2.204672298963783, -2.273689262333450,
                         -2.363714136353600, -2.644541000680772, -2.977651291726651))
expect_equal(r$w_Ih_final, c(0.112480560814322, 0.114600300867556, 0.115421108602301,
                           0.117372990660305, 0.122617649983886, 0.127906590822347))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_frazil_properties.html}
}
