% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pot_enthalpy_from_pt_ice_poly}
\alias{gsw_pot_enthalpy_from_pt_ice_poly}
\title{Potential Enthalpy of Ice (Polynomial version)}
\usage{
gsw_pot_enthalpy_from_pt_ice_poly(pt0_ice)
}
\arguments{
\item{pt0_ice}{potential temperature of ice (ITS-90) [ degC ]}
}
\value{
potential enthalpy [ J/kg ]
}
\description{
Potential Enthalpy of Ice (Polynomial version)
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
pt0_ice <- c(-10.7856, -13.4329, -12.8103, -12.2600,  -10.8863,  -8.4036)
e <- gsw_pot_enthalpy_from_pt_ice_poly(pt0_ice)
stopifnot(all.equal(e/1e5, c(-3.555459482216265, -3.608607100959428, -3.596153924697033,
                             -3.585123214031169, -3.557490561327994, -3.507198320793373)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pot_enthalpy_from_pt_ice_poly.html}
}
\seealso{
Other things related to enthalpy: 
\code{\link{gsw_CT_from_enthalpy}()},
\code{\link{gsw_dynamic_enthalpy}()},
\code{\link{gsw_enthalpy_CT_exact}()},
\code{\link{gsw_enthalpy_diff}()},
\code{\link{gsw_enthalpy_first_derivatives_CT_exact}()},
\code{\link{gsw_enthalpy_first_derivatives}()},
\code{\link{gsw_enthalpy_ice}()},
\code{\link{gsw_enthalpy_t_exact}()},
\code{\link{gsw_enthalpy}()},
\code{\link{gsw_frazil_properties_potential_poly}()},
\code{\link{gsw_frazil_properties_potential}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice}()},
\code{\link{gsw_pot_enthalpy_ice_freezing_poly}()},
\code{\link{gsw_pot_enthalpy_ice_freezing}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice_poly}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice}()},
\code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}()},
\code{\link{gsw_specvol_first_derivatives}()}
}
\concept{things related to enthalpy}
