% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substitution.R
\name{sub_values}
\alias{sub_values}
\title{Substitute targeted values in the table body}
\usage{
sub_values(
  data,
  columns = everything(),
  rows = everything(),
  values = NULL,
  pattern = NULL,
  fn = NULL,
  replacement = NULL,
  escape = TRUE
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{Optional columns for constraining the targeting process.
Providing \code{\link[=everything]{everything()}} (the default) results in cells in all \code{columns}
being targeting (this can be limited by \code{rows} however). Can either be a
series of column names provided in \code{\link[=c]{c()}}, a vector of column indices, or a
helper function focused on selections. The select helper functions are:
\code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows for constraining the targeting process. Providing
\code{\link[=everything]{everything()}} (the default) results in all rows in \code{columns} being
targeted. Alternatively, we can supply a vector of row captions within
\code{\link[=c]{c()}}, a vector of row indices, or a helper function focused on selections.
The select helper functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}},
\code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}.
We can also use expressions to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{values}{The specific value or values that should be replaced with a
\code{replacement} value. If \code{pattern} is also supplied then \code{values} will be
ignored.}

\item{pattern}{A regex pattern that can target solely those values in
\code{character}-based columns. If \code{values} is also supplied, \code{pattern} will
take precedence.}

\item{fn}{A supplied function that operates on \code{x} (the data in a column) and
should return a logical vector that matches the length of \code{x} (i.e., number
of rows in the input table). If either of \code{values} or \code{pattern} is also
supplied, \code{fn} will take precedence.}

\item{replacement}{The replacement value for any cell values matched by
either \code{values} or \code{pattern}. Must be a character or numeric vector of
length 1.}

\item{escape}{An option to escape replacement text according to the final
output format of the table. For example, if a LaTeX table is to be
generated then LaTeX escaping would be performed on the replacements during
rendering. By default this is set to \code{TRUE} but setting to \code{FALSE} would be
useful in the case where replacement text is crafted for a specific output
format in mind.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Should you need to replace specific cell values with custom text, the
\code{sub_values()} function can be good choice. We can target cells for
replacement though value, regex, and custom matching rules.
}
\section{Examples}{


Let's create an input table with three columns. This contains an assortment
of values that could potentially undergo some substitution via
\code{sub_values()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <-
  dplyr::tibble(
    num_1 = c(-0.01, 74, NA, 0, 500, 0.001, 84.3),
    int_1 = c(1L, -100000L, 800L, 5L, NA, 1L, -32L),
    lett = LETTERS[1:7]
  )

tbl
#> # A tibble: 7 x 3
#>     num_1   int_1 lett 
#>     <dbl>   <int> <chr>
#> 1  -0.01        1 A    
#> 2  74     -100000 B    
#> 3  NA         800 C    
#> 4   0           5 D    
#> 5 500          NA E    
#> 6   0.001       1 F    
#> 7  84.3       -32 G
}\if{html}{\out{</div>}}

Values in the table body cells can be replaced by specifying which values
should be replaced (in \code{values}) and what the replacement value should be.
It's okay to search for numerical or character values across all columns and
the replacement value can also be of the \code{numeric} or \code{character} types.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  gt() \%>\%
  sub_values(values = c(74, 500), replacement = 150) \%>\%
  sub_values(values = "B", replacement = "Bee") \%>\%
  sub_values(values = 800, replacement = "Eight hundred")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_values_1.png" alt="This image of a table was generated from the first code example in the `sub_values()` help file." style="width:100\%;">
}}

We can also use the \code{pattern} argument to target cell values for replacement
in \code{character}-based columns.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  gt() \%>\%
  sub_values(pattern = "A|C|E", replacement = "Ace")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_values_2.png" alt="This image of a table was generated from the second code example in the `sub_values()` help file." style="width:100\%;">
}}

For the most flexibility, it's best to use the \code{fn} argument. With that you
need to ensure that the function you provide will return a logical vector
when invoked on a column of cell values, taken as \code{x} (and, the length of
that vector must match the length of \code{x}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  gt() \%>\%
  sub_values(
    fn = function(x) x >= 0 & x < 50,
    replacement = "Between 0 and 50"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_values_3.png" alt="This image of a table was generated from the third code example in the `sub_values()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-21
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_zero}()},
\code{\link{text_transform}()}
}
\concept{data formatting functions}
