% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_horizontal_padding}
\alias{opt_horizontal_padding}
\title{Option to expand or contract horizontal padding}
\usage{
opt_horizontal_padding(data, scale = 1)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{scale}{\emph{Scale factor}

\verb{scalar<numeric|integer>(0>=val>=3)} // \emph{default:} \code{1}

A scale factor by which the horizontal padding will be adjusted. Must be a
number between \code{0} and \code{3}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Increase or decrease the horizontal padding throughout all locations of a
\strong{gt} table by use of a \code{scale} factor, which here is defined by a real
number between \code{0} and \code{3}. This function serves as a shortcut for setting
the following eight options in \code{\link[=tab_options]{tab_options()}}:
\itemize{
\item \code{heading.padding.horizontal}
\item \code{column_labels.padding.horizontal}
\item \code{data_row.padding.horizontal}
\item \code{row_group.padding.horizontal}
\item \code{summary_row.padding.horizontal}
\item \code{grand_summary_row.padding.horizontal}
\item \code{footnotes.padding.horizontal}
\item \code{source_notes.padding.horizontal}
}
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table with a number of table
parts added (using functions like \code{\link[=summary_rows]{summary_rows()}}, \code{\link[=grand_summary_rows]{grand_summary_rows()}},
and more). Following that, we'll increase the amount of horizontal padding
across the entire table with \code{opt_horizontal_padding()}. Using a \code{scale}
value of \code{3} (up from the default of \code{1}) means the horizontal space will
be greatly increased, resulting in a more spacious table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt(rowname_col = "row", groupname_col = "group") |>
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = c("min", "max")
  ) |>
  grand_summary_rows(
    columns = currency,
    fns = total ~ sum(., na.rm = TRUE)
  ) |>
  tab_source_note(source_note = "This is a source note.") |>
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) |>
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) |>
  opt_horizontal_padding(scale = 3)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_horizontal_padding_1.png" alt="This image of a table was generated from the first code example in the `opt_horizontal_padding()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-8
}

\section{Function Introduced}{

\code{v0.4.0} (February 15, 2022)
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_footnote_spec}()},
\code{\link{opt_interactive}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
