% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_to_dt.R
\name{emis_to_dt}
\alias{emis_to_dt}
\title{Convert emission estimates from list to data.table format}
\usage{
emis_to_dt(
  emi_list,
  emi_vars = "emi",
  veh_vars = "veh_type",
  pol_vars = "pollutant",
  segment_vars = NULL
)
}
\arguments{
\item{emi_list}{list. A list of emission estimates}

\item{emi_vars}{character. data.frame names of 'emi_list' object attributed
to emissions or  emission factors. Default is 'emi'.}

\item{veh_vars}{character. data.frame names of 'emi_list' object attributed
to vehicle characteristics. Default is 'veh_type'.}

\item{pol_vars}{character. data.frame names of 'emi_list' object attributed
to pollutants. Default is 'pollutant'.}

\item{segment_vars}{character. data.frame names of 'emi_list' object
attributed to the road segments. Default is NULL.}
}
\value{
data.table.
}
\description{
Read emission estimates generated by the \code{\link{emission_model}} or from
emission factor functions (e.g. \code{\link{ef_brazil_cetesb}}) and convert
them into a \code{data.table} format.
}
\examples{
\donttest{
library(gtfs2emis)
library(gtfstools)

# read GTFS
gtfs_file <- system.file("extdata/bra_cur_gtfs.zip", package = "gtfs2emis")
gtfs <- gtfstools::read_gtfs(gtfs_file) 

# keep a single trip_id to speed up this example
gtfs_small <- gtfstools::filter_by_trip_id(gtfs, trip_id ="4451136")
  
# run transport model
tp_model <- transport_model(gtfs_data = gtfs_small,
                            min_speed = 2,
                            max_speed = 80,
                            new_speed = 20,
                            spatial_resolution = 100,
                            parallel = FALSE)

# Example using Brazilian emission model and fleet
fleet_data_ef_cetesb <- data.frame(veh_type = "BUS_URBAN_D",
                                   model_year = 2010:2019,
                                   fuel = "D",
                                   fleet_composition = rep(0.1,10)
                                   )
                                   
emi_list <- emission_model(
                tp_model = tp_model,
                ef_model = "ef_brazil_cetesb",
                fleet_data = fleet_data_ef_cetesb,
                pollutant = c("CO","PM10","CO2","CH4","NOx")
                )

# convert emission list to data.table
dt <- emis_to_dt(emi_list)
}
}
\seealso{
Other emission analysis: 
\code{\link{emis_grid}()},
\code{\link{emis_summary}()}
}
\concept{emission analysis}
