% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_fields_exist}
\alias{check_fields_exist}
\alias{assert_fields_exist}
\title{Check the existence of fields in a GTFS object element}
\usage{
check_fields_exist(x, file, fields)

assert_fields_exist(x, file, fields)
}
\arguments{
\item{x}{A GTFS object.}

\item{file}{A string. The element, that represents a GTFS text file, where
fields should be searched.}

\item{fields}{A character vector. The fields to check the existence of.}
}
\value{
\code{check_fields_exist} returns \code{TRUE} if the check is successful, and
  \code{FALSE} otherwise. \cr
\code{assert_fields_exist} returns \code{x} invisibly if the check is
  successful, and throws an error otherwise.
}
\description{
Checks the existence of fields, represented by columns, inside a GTFS object
element.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")
gtfs <- import_gtfs(gtfs_path)

check_fields_exist(gtfs, "calendar", c("monday", "tuesday"))

check_fields_exist(gtfs, "calendar", c("monday", "oi"))

}
\seealso{
Other checking functions: 
\code{\link{check_fields_types}()},
\code{\link{check_files_exist}()}
}
\concept{checking functions}
