% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_pvalue.R
\name{fmt_pvalue}
\alias{fmt_pvalue}
\title{Formats p-values to be displayed in tables or text of report.}
\usage{
fmt_pvalue(x, digits = 1, prepend_p = FALSE)
}
\arguments{
\item{x}{numeric vector of p-values.}

\item{digits}{number of digits large p-values are rounded. Must be 1 or 2.
Default is 1.}

\item{prepend_p}{logical. Should 'p=' be prepended to formatted p-value. Default is FALSE}
}
\value{
Formatted p-values
}
\description{
Formats p-values to be displayed in tables or text of report.
}
\examples{
pvals <- c(
  1.5, 1, 0.999, 0.5, 0.25, 0.2, 0.197, 0.12, 0.10, 0.0999, 0.06,
  0.03, 0.002, 0.001, 0.00099, 0.0002, 0.00002, -1
)
fmt_pvalue(pvals)
fmt_pvalue(pvals, digits = 2, prepend_p = TRUE)
}
