% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_p.R
\name{bold_p.tbl_stack}
\alias{bold_p.tbl_stack}
\title{Bold significant p-values or q-values}
\usage{
\method{bold_p}{tbl_stack}(x, ...)
}
\arguments{
\item{x}{Object created using \link{tbl_stack} function}

\item{...}{arguments passed to \code{bold_p.*()} method that
matches the first object in the \code{tbl_stack}}
}
\value{
A \code{tbl_stack} object
}
\description{
Bold values below a chosen threshold (e.g. <0.05)
in \link{tbl_stack} tables.
}
\section{Example Output}{

\if{html}{\figure{bold_p_stack_ex.png}{options: width=50\%}}
}

\examples{
t1 <- tbl_regression(lm(age ~ response, trial))
t2 <- tbl_regression(lm(age ~ grade, trial))

bold_p_stack_ex <-
  tbl_stack(list(t1, t2)) \%>\%
  bold_p(t = 0.10)
}
\seealso{
Other tbl_uvregression tools: \code{\link{add_global_p.tbl_uvregression}},
  \code{\link{add_nevent.tbl_uvregression}},
  \code{\link{add_q.tbl_uvregression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_uvregression}},
  \code{\link{inline_text.tbl_uvregression}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_uvregression}},
  \code{\link{tbl_merge}}, \code{\link{tbl_stack}},
  \code{\link{tbl_uvregression}}

Other tbl_regression tools: \code{\link{add_global_p.tbl_regression}},
  \code{\link{add_nevent.tbl_regression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_regression}},
  \code{\link{inline_text.tbl_regression}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_regression}},
  \code{\link{tbl_merge}}, \code{\link{tbl_regression}},
  \code{\link{tbl_stack}}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
\concept{tbl_uvregression tools}
