% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_plus_plus_dots.R
\name{tidy_plus_plus_dots}
\alias{tidy_plus_plus_dots}
\title{Passing Arguments to \code{broom.helpers::tidy_plus_plus()}}
\description{
Functions \code{tbl_regression()} and \code{tbl_uvregression()} will pass any arguments
passed in the \code{...} to \code{broom.helpers::tidy_plus_plus(...)}.

There are restrictions, however, when passing arguments to
\code{tbl_uvregression()}. Keep in mind that serially constructs model objects
and passes these model objects to \code{tbl_regression()}. Lastly, this series
of  'tbl_regression' are stacked using \code{tbl_stack()}.

Because the arguments passed in \code{...} will be passed to \code{tbl_regression()}
for each model, you must ensure that the arguments passed will not
result in an error in \emph{any} of the calls to \code{tbl_regression()}.
For this reason, when passing arguments that take, for example, column names,
you must pass the names in \code{any_of()}.
For example, if you wanted remove reference rows, you would use:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{trial \%>\%
  tbl_uvregression(
    method = lm,
    y = age,
    include = c(trt, grade),
    no_reference_row =  any_of(c("trt", "grade"))
  )
}\if{html}{\out{</div>}}

For more flexible inputs that accept all tidyselect notation, you must utilize
\code{tbl_regression()} individually for each univariable model, and stack them
with \code{tbl_stack()}.
}
\keyword{internal}
