% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brdg_summary.R
\name{brdg_summary}
\alias{brdg_summary}
\alias{pier_summary_dichotomous}
\alias{pier_summary_categorical}
\alias{pier_summary_continuous2}
\alias{pier_summary_continuous}
\alias{pier_summary_missing_row}
\title{Summary table bridge}
\usage{
brdg_summary(
  cards,
  variables,
  type,
  statistic,
  by = NULL,
  missing = "no",
  missing_stat = "{N_miss}",
  missing_text = "Unknown"
)

pier_summary_dichotomous(cards, variables, statistic)

pier_summary_categorical(cards, variables, statistic)

pier_summary_continuous2(cards, variables, statistic)

pier_summary_continuous(cards, variables, statistic)

pier_summary_missing_row(
  cards,
  variables,
  missing = "no",
  missing_stat = "{N_miss}",
  missing_text = "Unknown"
)
}
\arguments{
\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{variables}{(\code{character})\cr
character list of variables}

\item{type}{(named \code{list})\cr
named list of summary types}

\item{statistic}{(named \code{list})\cr
named list of summary statistic names}

\item{by}{(\code{string})\cr
string indicating the stratifying column}

\item{missing, missing_text, missing_stat}{Arguments dictating how and if missing values are presented:
\itemize{
\item \code{missing}: must be one of \code{c("ifany", "no", "always")}.
\item \code{missing_text}: string indicating text shown on missing row. Default is \code{"Unknown"}.
\item \code{missing_stat}: statistic to show on missing row. Default is \code{"{N_miss}"}.
Possible values are \code{N_miss}, \code{N_obs}, \code{N_nonmiss}, \code{p_miss}, \code{p_nonmiss}.
}}
}
\value{
a gtsummary object
}
\description{
Bridge function for converting \code{tbl_summary()} (and similar) cards to basic gtsummary objects.
All bridge functions begin with prefix \verb{brdg_*()}.

This file also contains helper functions for constructing the bridge,
referred to as the piers (supports for a bridge) and begin with \verb{pier_*()}.
\itemize{
\item \code{brdg_summary()}: The bridge function ingests an ARD data frame and returns
a gtsummary table that includes \code{.$table_body} and a basic \code{.$table_styling}.
The \code{.$table_styling$header} data frame includes the header statistics.
Based on context, this function adds a column to the ARD data frame named
\code{"gts_column"}. This column is used during the reshaping in the \verb{pier_*()}
functions defining column names.
\item \verb{pier_*()}: these functions accept a cards tibble and returns a tibble
that is a piece of the \code{.$table_body}. Typically these will be stacked
to construct the final table body data frame. The ARD object passed here
will have two primary parts: the calculated summary statistics and the
attributes ARD. The attributes ARD is used for labeling. The ARD data frame
passed to this function must include a \code{"gts_column"} column, which is
added in \code{brdg_summary()}.
}
}
\examples{
library(cards)

# first build ARD data frame
cards <-
  ard_stack(
    mtcars,
    ard_continuous(variables = c("mpg", "hp")),
    ard_categorical(variables = "cyl"),
    ard_dichotomous(variables = "am"),
    .missing = TRUE,
    .attributes = TRUE
  ) |>
  # this column is used by the `pier_*()` functions
  dplyr::mutate(gts_column = ifelse(context == "attributes", NA, "stat_0"))

brdg_summary(
  cards = cards,
  variables = c("cyl", "am", "mpg", "hp"),
  type =
    list(
      cyl = "categorical",
      am = "dichotomous",
      mpg = "continuous",
      hp = "continuous2"
    ),
  statistic =
    list(
      cyl = "{n} / {N}",
      am = "{n} / {N}",
      mpg = "{mean} ({sd})",
      hp = c("{median} ({p25}, {p75})", "{mean} ({sd})")
    )
) |>
  as_tibble()

pier_summary_dichotomous(
  cards = cards,
  variables = "am",
  statistic = list(am = "{n} ({p})")
)

pier_summary_categorical(
  cards = cards,
  variables = "cyl",
  statistic = list(cyl = "{n} ({p})")
)

pier_summary_continuous2(
  cards = cards,
  variables = "hp",
  statistic = list(hp = c("{median}", "{mean}"))
)

pier_summary_continuous(
  cards = cards,
  variables = "mpg",
  statistic = list(mpg = "{median}")
)
}
