% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_proportions.R
\name{plot_proportions}
\alias{plot_proportions}
\alias{stratified_by}
\alias{dummy_proportions}
\title{Plot proportions by sub-groups}
\usage{
plot_proportions(
  data,
  condition,
  by = NULL,
  drop_na_by = FALSE,
  convert_continuous = TRUE,
  geom = "bar",
  ...,
  show_overall = TRUE,
  overall_label = "Overall",
  show_ci = TRUE,
  conf_level = 0.95,
  ci_color = "black",
  show_pvalues = TRUE,
  pvalues_test = c("fisher", "chisq"),
  pvalues_labeller = scales::label_pvalue(add_p = TRUE),
  pvalues_size = 3.5,
  show_labels = TRUE,
  label_y = NULL,
  labels_labeller = scales::label_percent(1),
  labels_size = 3.5,
  labels_color = "black",
  show_overall_line = FALSE,
  overall_line_type = "dashed",
  overall_line_color = "black",
  overall_line_width = 0.5,
  facet_labeller = ggplot2::label_wrap_gen(width = 50, multi_line = TRUE),
  flip = FALSE,
  minimal = FALSE,
  free_scale = FALSE,
  return_data = FALSE
)

stratified_by(condition, strata)

dummy_proportions(variable)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{condition}{<\code{\link[rlang:args_data_masking]{data-masking}}> A condition
defining a proportion, or a \code{\link[dplyr:reexports]{dplyr::tibble()}} defining several proportions
(see examples).}

\item{by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> List of variables to
group by (comparison is done separately for each variable).}

\item{drop_na_by}{Remove \code{NA} values in \code{by} variables?}

\item{convert_continuous}{Should continuous by variables (with 5 unique
values or more) be converted to quartiles (using \code{cut_quartiles()})?}

\item{geom}{Geometry to use for plotting proportions (\code{"bar"} by default).}

\item{...}{Additional arguments passed to the geom defined by \code{geom}.}

\item{show_overall}{Display "Overall" column?}

\item{overall_label}{Label for the overall column.}

\item{show_ci}{Display confidence intervals?}

\item{conf_level}{Confidence level for the confidence intervals.}

\item{ci_color}{Color of the error bars representing confidence intervals.}

\item{show_pvalues}{Display p-values in the top-left corner?}

\item{pvalues_test}{Test to compute p-values for data frames: \code{"fisher"} for
\code{\link[stats:fisher.test]{stats::fisher.test()}} (with \code{simulate.p.value = TRUE}) or \code{"chisq"} for
\code{\link[stats:chisq.test]{stats::chisq.test()}}. Has no effect on survey objects for those
\code{\link[survey:svychisq]{survey::svychisq()}} is used.}

\item{pvalues_labeller}{Labeller function for p-values.}

\item{pvalues_size}{Text size for p-values.}

\item{show_labels}{Display proportion labels?}

\item{label_y}{Y position of labels. If \code{NULL}, will be auto-determined.}

\item{labels_labeller}{Labeller function for labels.}

\item{labels_size}{Size of labels.}

\item{labels_color}{Color of labels.}

\item{show_overall_line}{Add an overall line?}

\item{overall_line_type}{Line type of the overall line.}

\item{overall_line_color}{Color of the overall line.}

\item{overall_line_width}{Line width of the overall line.}

\item{facet_labeller}{Labeller function for strip labels.}

\item{flip}{Flip x and y axis?}

\item{minimal}{Should a minimal theme be applied? (no y-axis, no grid)}

\item{free_scale}{Allow y axis to vary between conditions?}

\item{return_data}{Return computed data instead of the plot?}

\item{strata}{Stratification variable}

\item{variable}{Variable to be converted into dummy variables.}
}
\description{
Plot one or several proportions (defined by logical conditions) by
sub-groups. See \code{\link[=proportion]{proportion()}} for more details on the way proportions and
confidence intervals are computed. By default, return a bar plot, but other
geometries could be used (see examples). \code{stratified_by()} is an helper
function facilitating a stratified analyses (i.e. proportions by groups
stratified according to a third variable, see examples).
\code{dummy_proportions()} is an helper to easily convert a categorical variable
into dummy variables and therefore showing the proportion of each level of
the original variable (see examples).
}
\examples{
titanic |>
  plot_proportions(
    Survived == "Yes",
    overall_label = "All",
    labels_color = "white"
  )

titanic |>
  plot_proportions(
    Survived == "Yes",
    by = c(Class, Sex),
    fill = "lightblue"
  )

\donttest{

titanic |>
  plot_proportions(
    Survived == "Yes",
    by = c(Class, Sex),
    fill = "lightblue",
    flip = TRUE
  )

titanic |>
  plot_proportions(
    Survived == "Yes",
    by = c(Class, Sex),
    fill = "lightblue",
    minimal = TRUE
  )

titanic |>
  plot_proportions(
    Survived == "Yes",
    by = c(Class, Sex),
    geom = "point",
    color = "red",
    size = 3,
    show_labels = FALSE
  )

titanic |>
  plot_proportions(
    Survived == "Yes",
    by = c(Class, Sex),
    geom = "area",
    fill = "lightgreen",
    show_overall = FALSE
  )

titanic |>
  plot_proportions(
    Survived == "Yes",
    by = c(Class, Sex),
    geom = "line",
    color = "purple",
    ci_color = "darkblue",
    show_overall = FALSE
  )

titanic |>
  plot_proportions(
    Survived == "Yes",
    by = -Survived,
    mapping = ggplot2::aes(fill = by),
    color = "black",
    show.legend = FALSE,
    show_overall_line = TRUE,
    show_pvalues = FALSE
 )

# defining several proportions

titanic |>
  plot_proportions(
    dplyr::tibble(
      Survived = Survived == "Yes",
      Male = Sex == "Male"
    ),
    by = c(Class),
    mapping = ggplot2::aes(fill = condition)
  )

titanic |>
  plot_proportions(
    dplyr::tibble(
      Survived = Survived == "Yes",
      Male = Sex == "Male"
    ),
    by = c(Class),
    mapping = ggplot2::aes(fill = condition),
    free_scale = TRUE
  )

iris |>
  plot_proportions(
    dplyr::tibble(
      "Long sepal" = Sepal.Length > 6,
      "Short petal" = Petal.Width < 1
    ),
    by = Species,
    fill = "palegreen"
  )

iris |>
  plot_proportions(
    dplyr::tibble(
      "Long sepal" = Sepal.Length > 6,
      "Short petal" = Petal.Width < 1
    ),
    by = Species,
    fill = "palegreen",
    flip = TRUE
  )

# works with continuous by variables
iris |>
  labelled::set_variable_labels(
    Sepal.Length = "Length of the sepal"
  ) |>
  plot_proportions(
    Species == "versicolor",
    by = dplyr::contains("leng"),
    fill = "plum",
    colour = "plum4"
  )

# works with survey object
titanic |>
  srvyr::as_survey() |>
  plot_proportions(
    Survived == "Yes",
    by = c(Class, Sex),
    fill = "darksalmon",
    color = "black",
    show_overall_line = TRUE,
    labels_labeller = scales::label_percent(.1)
 )
}

# stratified analysis
titanic |>
  plot_proportions(
    (Survived == "Yes") |>  stratified_by(Sex),
    by = Class,
    mapping = ggplot2::aes(fill = condition)
  ) +
  ggplot2::theme(legend.position = "bottom") +
  ggplot2::labs(fill = NULL)

# Convert Class into dummy variables
titanic |>
  plot_proportions(
    dummy_proportions(Class),
    by = Sex,
    mapping = ggplot2::aes(fill = level)
  )
}
\keyword{hplot}
