% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical.diag.R
\name{elliptical.diag}
\alias{elliptical.diag}
\title{Diagnostic for Elliptical Regression Models}
\usage{
elliptical.diag(ellipticalfit, weighting = "observed", ...)
}
\arguments{
\item{ellipticalfit}{fit object for elliptical regression model.}

\item{weighting}{type of model weighting used.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns a list of diagnostic arrays:
\item{resid}{ordinal residuals for the fit model.}
\item{rs}{studentized residuals for the fit model.}
\item{dispersion}{coefficient of dispersion for the model fit.}
\item{GL}{generalized leverage for the model fit.}
\item{GLbeta}{generalized leverage of location parameters estimation for the model fit.}
\item{GLphi}{generalized leverage of dispersion parameters estimation for the model fit.}  
\item{Bi}{generalized leverage weighted by dispersion for the model fit.}
\item{Om}{observed fisher information matrix of the model fit.}
\item{Iom}{expected fisher information matrix of the model fit.}  
\item{a, b, c}{the value of D(a), D(b) and D(c), respectively, for the model fit.}
\item{Cmax}{matrix of local influence for additive perturbation in response.}
\item{Lmax}{matrix of local influence on coefficients (additive perturbation in predictors).}
\item{Cic}{matrix of local influence for case-weight perturbation (Ci).}
\item{dmax}{matrix of local influence for case-weight perturbation (dmax).}
\item{dmaxc}{matrix of local influence for case-weight perturbation (|dmax|).}
\item{Ci}{matrix of local influence on the scale.}
\item{Cih}{main diagonal of the matrix of local influence on the scale.}
\item{h}{main diagonal of the hat matrix.}
}
\description{
This function obtains the values of the residuals and calculates the diagnostic measures for elliptical regression models.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5),
data=luz)
elliptical.diag(elliptical.fitt)
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\url{https://doi.org/10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{elliptical}}
}
\keyword{diagnostic}
\keyword{elliptical}
\keyword{methods}
