% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{buildItem}
\alias{buildItem}
\alias{buildOneItem}
\title{Build a model suitable for a single item genome-wide association study}
\usage{
buildItem(
  phenoData,
  depVar,
  covariates = NULL,
  ...,
  fitfun = c("WLS", "ML"),
  minMAF = 0.01,
  gxe = NULL,
  exogenous = NA
)
}
\arguments{
\item{phenoData}{A matrix or data.frame which provides all of the phenotype data to the model (both the items and the covariates). Data should be constructed so that variables are on the columns and individuals are on the rows.}

\item{depVar}{the name of items to predict}

\item{covariates}{A vector of data column names (from \code{phenoData}) to use as covariates (e.g. age, sex, and ancestry principle components).}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfun}{A character string naming the fit function used to optimize the model. Must be either \sQuote{WLS} or \sQuote{ML}.}

\item{minMAF}{A numerical value that specifies the minimum valid minor allele frequency for a SNP. SNPs with minimum minor allele frequencies that are smaller than the minMAF value will not be analyzed. Only used when \code{fitfun=WLS}}

\item{gxe}{a vector of data column names. Creates additional data
columns named paste0('snp_',columnName) that are the product of
the SNP and the data in columnName. Add these new data columns to
your list of covariates to use them as covariates.}

\item{exogenous}{logical value. Whether the covariates should be treated as exogenous (TRUE) or endogenous (FALSE).}
}
\value{
A \link[OpenMx:MxModel-class]{MxModel}
}
\description{
\lifecycle{maturing}
}
\details{
This function is designed to be passed to the \link{GWAS} function. The model that is returned, however, is a valid OpenMx model and can be fitted using \link[OpenMx]{mxRun} or \link[OpenMx]{mxTryHard}. Models should be tested to ensure that they are identified and fit the data as expected to avoid unnecessary computation of an invalid model.

There is no limit on the number of items that can be included, but more items will exponentially increase computation time.  To address this, we suggest that users use the \sQuote{WLS} fit function. The \sQuote{WLS} fit function is dramatically faster than the \sQuote{ML} fit function, especially for ordinal items.

Ordinal indicator thresholds are setup by
\link{setupThresholds}. Exogenous covariates adjustments are setup by
\link{setupExogenousCovariates}.
You can plot the model using \link[OpenMx]{omxGraphviz}.
}
\section{WLS Technical Note}{

When the \code{depVar} item is/are continuous,
covariates are endogenous (the default),
and the fit function is \code{WLS} then the
\code{cumulants} method is used to create observed summary
statistics (see \link[OpenMx]{mxFitFunctionWLS}). In other cases,
the \code{marginals} method is used. The \code{cumulants} method is
more accurate than \code{marginals}. The difference in accuracy
becomes vivid when comparing estimates against the \code{ML} fit
function.
}

\examples{
pheno <- data.frame(anxiety=cut(rnorm(500), c(-Inf, -.5, .5, Inf),
                    ordered_result = TRUE))
m1 <- buildItem(pheno, 'anxiety')
}
\seealso{
Other model builder: 
\code{\link{buildOneFacRes}()},
\code{\link{buildOneFac}()},
\code{\link{buildTwoFac}()}
}
\concept{model builder}
