% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gyro.R
\encoding{UTF-8}
\name{plotGyrohull3d}
\alias{plotGyrohull3d}
\title{Hyperbolic convex hull}
\usage{
plotGyrohull3d(
  points,
  s = 1,
  model = "U",
  iterations = 5,
  n = 100,
  edgesAsTubes = TRUE,
  verticesAsSpheres = edgesAsTubes,
  edgesColor = "yellow",
  spheresColor = edgesColor,
  tubesRadius = 0.03,
  spheresRadius = 0.05,
  facesColor = "navy",
  bias = 1,
  interpolate = "linear",
  g = identity
)
}
\arguments{
\item{points}{matrix of 3D points, one point per row}

\item{s}{positive number, the radius of the Poincaré ball if
\code{model="M"}, otherwise, if \code{model="U"}, this number
defines the hyperbolic curvature (the smaller, the more curved)}

\item{model}{the hyperbolic model, either \code{"M"} (Möbius model, i.e.
Poincaré model) or \code{"U"} (Ungar model, i.e. hyperboloid model)}

\item{iterations}{argument passed to \code{\link{gyrotriangle}}}

\item{n}{argument passed to \code{\link{gyrotube}} or
\code{\link{gyrosegment}}, the number of points for each edge}

\item{edgesAsTubes}{Boolean, whether to represent tubular edges}

\item{verticesAsSpheres}{Boolean, whether to represent the vertices as
spheres}

\item{edgesColor}{a color for the edges}

\item{spheresColor}{a color for the spheres, if
\code{verticesAsSpheres = TRUE}}

\item{tubesRadius}{radius of the tubes, if \code{edgesAsTubes = TRUE}}

\item{spheresRadius}{radius of the spheres,
if \code{verticesAsSpheres = TRUE}}

\item{facesColor}{this argument sets the color of the faces; it can be
either a single color or a color palette, i.e. a vector of colors; if it
is a color palette, it will be passed to the argument \code{palette} of
\code{\link{gyrotriangle}}}

\item{bias, interpolate, g}{these arguments are passed to
\code{\link{gyrotriangle}} in the case when \code{facesColor} is a color
palette}
}
\value{
No value, called for plotting.
}
\description{
Plot the hyperbolic convex hull of a set of 3D points.
}
\examples{
library(gyro)
library(rgl)
# Triangular orthobicopula ####
points <- rbind(
  c(1, -1/sqrt(3), sqrt(8/3)),
  c(1, -1/sqrt(3), -sqrt(8/3)),
  c(-1, -1/sqrt(3), sqrt(8/3)),
  c(-1, -1/sqrt(3), -sqrt(8/3)),
  c(0, 2/sqrt(3), sqrt(8/3)),
  c(0, 2/sqrt(3), -sqrt(8/3)),
  c(1, sqrt(3), 0),
  c(1, -sqrt(3), 0),
  c(-1, sqrt(3), 0),
  c(-1, -sqrt(3), 0),
  c(2, 0, 0),
  c(-2, 0, 0)
)
\donttest{open3d(windowRect = c(50, 50, 562, 562))
view3d(zoom = 0.7)
plotGyrohull3d(points, s = 0.4)}

# a non-convex polyhedron with triangular faces ####
vertices <- rbind(
  c(-2.1806973249, -2.1806973249, -2.1806973249),
  c(-3.5617820682, 0.00000000000, 0.00000000000),
  c(0.00000000000, -3.5617820682, 0.00000000000),
  c(0.00000000000, 0.00000000000, -3.5617820682),
  c(-2.1806973249, -2.1806973249, 2.18069732490),
  c(0.00000000000, 0.00000000000, 3.56178206820),
  c(-2.1806973249, 2.18069732490, -2.1806973249),
  c(0.00000000000, 3.56178206820, 0.00000000000),
  c(-2.1806973249, 2.18069732490, 2.18069732490),
  c(2.18069732490, -2.1806973249, -2.1806973249),
  c(3.56178206820, 0.00000000000, 0.00000000000),
  c(2.18069732490, -2.1806973249, 2.18069732490),
  c(2.18069732490, 2.18069732490, -2.1806973249),
  c(2.18069732490, 2.18069732490, 2.18069732490))
triangles <- 1 + rbind(
  c(3, 2, 0),
  c(0, 1, 3),
  c(2, 1, 0),
  c(4, 2, 5),
  c(5, 1, 4),
  c(4, 1, 2),
  c(6, 7, 3),
  c(3, 1, 6),
  c(6, 1, 7),
  c(5, 7, 8),
  c(8, 1, 5),
  c(7, 1, 8),
  c(9, 2, 3),
  c(3, 10, 9),
  c(9, 10, 2),
  c(5, 2, 11),
  c(11, 10, 5),
  c(2, 10, 11),
  c(3, 7, 12),
  c(12, 10, 3),
  c(7, 10, 12),
  c(13, 7, 5),
  c(5, 10, 13),
  c(13, 10, 7))
edges0 <- do.call(c, lapply(1:nrow(triangles), function(i){
  face <- triangles[i, ]
  list(
    sort(c(face[1], face[2])),
    sort(c(face[1], face[3])),
    sort(c(face[2], face[3]))
  )
}))
edges <- do.call(rbind, edges0)
edges <- edges[!duplicated(edges), ]
s <- 2
\donttest{library(rgl)
open3d(windowRect = c(50, 50, 1074, 562))
mfrow3d(1, 2)
view3d(zoom = 0.65)
for(i in 1:nrow(triangles)){
  triangle <- triangles[i, ]
  A <- vertices[triangle[1], ]
  B <- vertices[triangle[2], ]
  C <- vertices[triangle[3], ]
  gtriangle <- gyrotriangle(A, B, C, s)
  shade3d(gtriangle, color = "violetred")
}
for(i in 1:nrow(edges)){
  edge <- edges[i, ]
  A <- vertices[edge[1], ]
  B <- vertices[edge[2], ]
  gtube <- gyrotube(A, B, s, radius = 0.06)
  shade3d(gtube, color = "darkviolet")
}
spheres3d(vertices, radius = 0.09, color = "deeppink")
# now plot the hyperbolic convex hull
next3d()
view3d(zoom = 0.65)
plotGyrohull3d(vertices, s)}

# an example of color palette ####
library(trekcolors)
library(uniformly)
set.seed(666)
points <- runif_on_sphere(50, d = 3)
\donttest{open3d(windowRect = c(50, 50, 562, 562))
plotGyrohull3d(
  points, edgesColor = "brown",
  facesColor = trek_pal("lcars_series"), g = function(u) 1-u^2
)}
}
