# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- H2O Stacked Ensemble -------------------------- #
#' 
#' Builds a Stacked Ensemble
#' 
#' Build a stacked ensemble (aka. Super Learner) using the H2O base
#' learning algorithms specified by the user.
#' 
#' @param x (Optional). A vector containing the names or indices of the predictor variables to use in building the model.
#'           If x is missing, then all columns except y are used.  Training frame is used only to compute ensemble training metrics. 
#' @param y The name or column index of the response variable in the data. The response must be either a numeric or a
#'        categorical/factor variable. If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param training_frame Id of the training data frame.
#' @param validation_frame Id of the validation data frame.
#' @param base_models List of models (or model ids) to ensemble/stack together. Models must have been cross-validated using nfolds >
#'        1, and folds must be identical across models. Defaults to [].
#' @param metalearner_algorithm Type of algorithm to use as the metalearner. Options include 'AUTO' (GLM with non negative weights; if
#'        validation_frame is present, a lambda search is performed), 'glm' (GLM with default parameters), 'gbm' (GBM
#'        with default parameters), 'drf' (Random Forest with default parameters), or 'deeplearning' (Deep Learning with
#'        default parameters). Must be one of: "AUTO", "glm", "gbm", "drf", "deeplearning". Defaults to AUTO.
#' @param metalearner_nfolds Number of folds for K-fold cross-validation of the metalearner algorithm (0 to disable or >= 2). Defaults to
#'        0.
#' @param metalearner_fold_assignment Cross-validation fold assignment scheme for metalearner cross-validation.  Defaults to AUTO (which is
#'        currently set to Random). The 'Stratified' option will stratify the folds based on the response variable, for
#'        classification problems. Must be one of: "AUTO", "Random", "Modulo", "Stratified".
#' @param metalearner_fold_column Column with cross-validation fold index assignment per observation for cross-validation of the metalearner.
#' @param keep_levelone_frame \code{Logical}. Keep level one frame used for metalearner training. Defaults to FALSE.
#' @param metalearner_params Parameters for metalearner algorithm Defaults to NULL.
#' @param seed Seed for random numbers; passed through to the metalearner algorithm. Defaults to -1 (time-based random number)
#'        Defaults to -1 (time-based random number).
#' @examples
#' 
#' # See example R code here:
#' # http://docs.h2o.ai/h2o/latest-stable/h2o-docs/data-science/stacked-ensembles.html
#' 
#' @export
h2o.stackedEnsemble <- function(x, y, training_frame,
                                model_id = NULL,
                                validation_frame = NULL,
                                base_models = list(),
                                metalearner_algorithm = c("AUTO", "glm", "gbm", "drf", "deeplearning"),
                                metalearner_nfolds = 0,
                                metalearner_fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
                                metalearner_fold_column = NULL,
                                keep_levelone_frame = FALSE,
                                seed = -1,
                                metalearner_params = NULL 
                                ) 
{
  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(y)) {
         x <- setdiff(col(training_frame), y)
     } else {
         x <- setdiff(colnames(training_frame), y)
     }
  }

  # Required args: training_frame
  if (missing(training_frame)) stop("argument 'training_frame' is missing, with no default")
  # Training_frame must be a key or an H2OFrame object
  if (!is.H2OFrame(training_frame))
     tryCatch(training_frame <- h2o.getFrame(training_frame),
           error = function(err) {
             stop("argument 'training_frame' must be a valid H2OFrame or key")
           })
  # Validation_frame must be a key or an H2OFrame object
  if (!is.null(validation_frame)) {
     if (!is.H2OFrame(validation_frame))
         tryCatch(validation_frame <- h2o.getFrame(validation_frame),
             error = function(err) {
                 stop("argument 'validation_frame' must be a valid H2OFrame or key")
             })
  }
  # Parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, y)
  parms$response_column <- args$y

 if (length(base_models) == 0) stop('base_models is empty')
  # If base_models contains models instead of ids, replace with model id
  for (i in 1:length(base_models)) {
    if (inherits(base_models[[i]], 'H2OModel')) {
      base_models[[i]] <- base_models[[i]]@model_id
    }
  }
 
  if (!missing(metalearner_params))
      parms$metalearner_params <- as.character(toJSON(metalearner_params, pretty = TRUE))
  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(validation_frame))
    parms$validation_frame <- validation_frame
  if (!missing(base_models))
    parms$base_models <- base_models
  if (!missing(metalearner_algorithm))
    parms$metalearner_algorithm <- metalearner_algorithm
  if (!missing(metalearner_nfolds))
    parms$metalearner_nfolds <- metalearner_nfolds
  if (!missing(metalearner_fold_assignment))
    parms$metalearner_fold_assignment <- metalearner_fold_assignment
  if (!missing(metalearner_fold_column))
    parms$metalearner_fold_column <- metalearner_fold_column
  if (!missing(keep_levelone_frame))
    parms$keep_levelone_frame <- keep_levelone_frame
  if (!missing(seed))
    parms$seed <- seed
  # Error check and build model
  model <- .h2o.modelJob('stackedensemble', parms, h2oRestApiVersion = 99)
  #Convert metalearner_params back to list if not NULL
  if (!missing(metalearner_params)) {
      model@parameters$metalearner_params <- list(fromJSON(model@parameters$metalearner_params))
  }
  return(model)
}
