% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.getGrid}
\alias{h2o.getGrid}
\title{Get a grid object from H2O distributed K/V store.}
\usage{
h2o.getGrid(grid_id, conn = h2o.getConnection())
}
\arguments{
\item{grid_id}{ID of existing grid object to fetch}

\item{conn}{H2O connection}
}
\description{
Get a grid object from H2O distributed K/V store.
}
\examples{
library(h2o)
library(jsonlite)
localH2O <- h2o.init()
iris.hex <- as.h2o(iris)
h2o.grid("gbm", grid_id = "gbm_grid", x = c(1:4), y = 5,
         training_frame = iris.hex, hyper_params = list(ntrees = c(1,2,3)))
grid <- h2o.getGrid("gbm_grid")
# Get grid summary
summary(grid)
# Fetch grid models
model_ids <- grid@model_ids
models <- lapply(model_ids, function(id) { h2o.getModel(id)})
}

