% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{as.factor}
\alias{as.factor}
\title{Convert H2O Data to Factors}
\usage{
as.factor(x)
}
\arguments{
\item{x}{a column from an H2OFrame data set.}
}
\description{
Convert a column into a factor column.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate[, 2] <- as.factor(prostate[, 2])
summary(prostate)
}
}
\seealso{
\code{\link{as.factor}}.
}
