% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{uncompact}
\alias{uncompact}
\title{Uncompact H3 cell indices}
\usage{
uncompact(h3_addresses = NULL, res = NULL, simple = TRUE)
}
\arguments{
\item{h3_addresses}{Character vector or list of 15-character cell indices
generated by H3.}

\item{res}{Integer; Desired H3 resolution. See
\url{https://h3geo.org/docs/core-library/restable/} for allowable values and related dimensions.}

\item{simple}{Logical; whether to return a vector of outputs or a list object
containing both inputs and outputs.}
}
\value{
A list of H3 cell indices of the chosen resolution.
}
\description{
This function uncompacts a compacted set of H3 cells to indices of the
target resolution.
}
\examples{
\dontrun{
# Give me a compacted representation of County Ashe, NC
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
nc1 <- nc[1, ]
nc1 <- sf::st_cast(nc1, 'POLYGON')
fillers <- polygon_to_cells(geometry = nc1, res = 6)
compacted <- compact(fillers)
# uncompact to resolution 7
uncompacted <- uncompact(compacted, res = 7)
}
}
