% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printFit.R
\name{printFit}
\alias{printFit}
\title{Print model-fits (mean LOOIC and WAIC values) of hBayesDM Models}
\usage{
printFit(..., ncore = 2, roundTo = 3)
}
\arguments{
\item{...}{Model objects output by hBayesDM functions (e.g. output1, output2, etc.)}

\item{ncore}{Numer of cores to use when computing leave-one-out cross-validation}

\item{roundTo}{Number of digits to the right of the decimal point in the output}
}
\value{
modelTable A table with relevant model comparison data
}
\description{
Print model-fits (mean LOOIC and WAIC values) of hBayesDM Models
}
\examples{
\dontrun{
# Run two models and store results in "output1" and "output2"
output1 <- dd_hyperbolic("example", 2000, 1000, 3, 3)

output2 <- dd_exp("example", 2000, 1000, 3, 3)

# Show the WAIC and LOOIC model fit estimates 
printFit(output1, outpu2)
}
}

