% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiNMF.R
\name{semiNMF}
\alias{semiNMF}
\title{Semi-NMF based on multiplicative update rules. Reference:  C. Ding, T. Li, and M.I. Jordan,
"Convex and semi-nonnegative matrix factorizations",
IEEE Transations on Pattern Analysis and Machine Intelligence,
vol. 32, no. 1, pp. 45-55, 2010.}
\usage{
semiNMF(X, nmfMod, maxiter = 2000, checkDivergence = FALSE)
}
\arguments{
\item{X}{Input data matrix, each column represents one observation 
and the rows correspond to the different features}

\item{nmfMod}{Valid NMF model, containing initialized factor matrices
(in accordance with the NMF package definition)}

\item{maxiter}{Maximum number of iterations}

\item{checkDivergence}{currently not in use, to be implemented}
}
\value{
Resulting NMF model (in accordance with the NMF package definition)
}
\description{
Semi-NMF based on multiplicative update rules. Reference:  C. Ding, T. Li, and M.I. Jordan,
"Convex and semi-nonnegative matrix factorizations",
IEEE Transations on Pattern Analysis and Machine Intelligence,
vol. 32, no. 1, pp. 45-55, 2010.
}
\author{
nsauwen
}
