% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_age_models.R
\name{calc_mse}
\alias{calc_mse}
\alias{calc_rmse}
\title{Calculate mean-squared-error (MSE) and root mean-squared-error (RMSE) of
estimated ages}
\usage{
calc_mse(data, age_col = "age")

calc_rmse(data, age_col = "age")
}
\arguments{
\item{data}{A data.frame as created by \code{\link{assign_ages}}}

\item{age_col}{Character. Name of the age column in \code{data}}
}
\value{
Numeric value for estimated ages with no levels or a data.frame with
a MSE or RMSE value for each level used to fit ages
}
\description{
These functions will calculate MSE and RMSE for estimated ages produced by
\code{\link{assign_ages}}. Output is specific to each level used by the
age-length key to assign ages
}
\examples{
wae_data <- spp_data[spp_data$spp == "walleye", ]
alk <- make_alk(wae_data)
wae_est_age <- assign_ages(wae_data, alk)
calc_mse(wae_est_age)
calc_rmse(wae_est_age)
}
