% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{alpha}
\alias{alpha}
\title{Calculates Cronbach's alpha on scale items}
\usage{
alpha(items, data)
}
\arguments{
\item{items}{Vector of item names that form a scale (e.g., 5-point Likert scales)}

\item{data}{Data frame object.}
}
\value{
A list object with Cronbach's alpha summary statistics.
}
\description{
Performs Cronbach's alpha of specified items from a data frame.
Cronbach's Alpha is a formula for estimating the internal consistency
reliability of a measurement instrument such as survey items  (see Allen & Yang, 1979; Kline, 1999).
Survey items can have 2 or more categories such as 5-point scales and contain 2 or more items.
}
\examples{
alpha(items=c("i1","i2","i3","i4","i5"), data=cas)

# remove i1 as suggested in the previous example, returns higher alpha
alpha(items=c("i2","i3","i4","i5"), data=cas)
}
\references{
Allen, M. J., & Yen, W. M. (1979). Introduction to Measurement Theory.
Brooks/Cole. ISBN: 0-8185-0283-5.
Kline, Paul (1999). Handbook of Psychological Testing (2nd ed).
Routledge, New York. ISBN: 9780415211581.
}
